/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.ListSizeConstraintSetsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListSizeConstraintSetsRequestMarshaller
implements Marshaller<Request<ListSizeConstraintSetsRequest>, ListSizeConstraintSetsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListSizeConstraintSetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListSizeConstraintSetsRequest> marshall(ListSizeConstraintSetsRequest listSizeConstraintSetsRequest) {
        if (listSizeConstraintSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListSizeConstraintSetsRequest> request = new DefaultRequest<ListSizeConstraintSetsRequest>(listSizeConstraintSetsRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.ListSizeConstraintSets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listSizeConstraintSetsRequest.getNextMarker() != null) {
                jsonGenerator.writeFieldName("NextMarker").writeValue(listSizeConstraintSetsRequest.getNextMarker());
            }
            if (listSizeConstraintSetsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listSizeConstraintSetsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

