/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.LoggingOptionsPayload;
import com.amazonaws.services.iot.model.SetLoggingOptionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SetLoggingOptionsRequestMarshaller
implements Marshaller<Request<SetLoggingOptionsRequest>, SetLoggingOptionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetLoggingOptionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SetLoggingOptionsRequest> marshall(SetLoggingOptionsRequest setLoggingOptionsRequest) {
        if (setLoggingOptionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetLoggingOptionsRequest> request = new DefaultRequest<SetLoggingOptionsRequest>(setLoggingOptionsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/loggingOptions";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            LoggingOptionsPayload loggingOptionsPayload = setLoggingOptionsRequest.getLoggingOptionsPayload();
            if (loggingOptionsPayload != null) {
                jsonGenerator.writeStartObject();
                if (loggingOptionsPayload.getRoleArn() != null) {
                    jsonGenerator.writeFieldName("roleArn").writeValue(loggingOptionsPayload.getRoleArn());
                }
                if (loggingOptionsPayload.getLogLevel() != null) {
                    jsonGenerator.writeFieldName("logLevel").writeValue(loggingOptionsPayload.getLogLevel());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

