/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.transform.DeploymentConfigurationJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.LoadBalancerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateServiceRequestMarshaller
implements Marshaller<Request<CreateServiceRequest>, CreateServiceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateServiceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateServiceRequest> marshall(CreateServiceRequest createServiceRequest) {
        if (createServiceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateServiceRequest> request = new DefaultRequest<CreateServiceRequest>(createServiceRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.CreateService");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList loadBalancersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createServiceRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(createServiceRequest.getCluster());
            }
            if (createServiceRequest.getServiceName() != null) {
                jsonGenerator.writeFieldName("serviceName").writeValue(createServiceRequest.getServiceName());
            }
            if (createServiceRequest.getTaskDefinition() != null) {
                jsonGenerator.writeFieldName("taskDefinition").writeValue(createServiceRequest.getTaskDefinition());
            }
            if (!(loadBalancersList = (SdkInternalList)createServiceRequest.getLoadBalancers()).isEmpty() || !loadBalancersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("loadBalancers");
                jsonGenerator.writeStartArray();
                for (LoadBalancer loadBalancersListValue : loadBalancersList) {
                    if (loadBalancersListValue == null) continue;
                    LoadBalancerJsonMarshaller.getInstance().marshall(loadBalancersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createServiceRequest.getDesiredCount() != null) {
                jsonGenerator.writeFieldName("desiredCount").writeValue(createServiceRequest.getDesiredCount());
            }
            if (createServiceRequest.getClientToken() != null) {
                jsonGenerator.writeFieldName("clientToken").writeValue(createServiceRequest.getClientToken());
            }
            if (createServiceRequest.getRole() != null) {
                jsonGenerator.writeFieldName("role").writeValue(createServiceRequest.getRole());
            }
            if (createServiceRequest.getDeploymentConfiguration() != null) {
                jsonGenerator.writeFieldName("deploymentConfiguration");
                DeploymentConfigurationJsonMarshaller.getInstance().marshall(createServiceRequest.getDeploymentConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

