/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.Snapshot;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeSnapshotsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Snapshot> snapshots;
    private String nextToken;

    public List<Snapshot> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new SdkInternalList();
        }
        return this.snapshots;
    }

    public void setSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
            return;
        }
        this.snapshots = new SdkInternalList<Snapshot>(snapshots);
    }

    public DescribeSnapshotsResult withSnapshots(Snapshot ... snapshots) {
        if (this.snapshots == null) {
            this.setSnapshots(new SdkInternalList<Snapshot>(snapshots.length));
        }
        for (Snapshot ele : snapshots) {
            this.snapshots.add(ele);
        }
        return this;
    }

    public DescribeSnapshotsResult withSnapshots(Collection<Snapshot> snapshots) {
        this.setSnapshots(snapshots);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeSnapshotsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshots() != null) {
            sb.append("Snapshots: " + this.getSnapshots() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResult)) {
            return false;
        }
        DescribeSnapshotsResult other = (DescribeSnapshotsResult)obj;
        if (other.getSnapshots() == null ^ this.getSnapshots() == null) {
            return false;
        }
        if (other.getSnapshots() != null && !other.getSnapshots().equals(this.getSnapshots())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshots() == null ? 0 : this.getSnapshots().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeSnapshotsResult clone() {
        try {
            return (DescribeSnapshotsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

