/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.RouteFilterPrefix;
import com.amazonaws.services.directconnect.model.VirtualInterface;
import com.amazonaws.services.directconnect.model.transform.RouteFilterPrefixJsonMarshaller;

public class VirtualInterfaceJsonMarshaller {
    private static VirtualInterfaceJsonMarshaller instance;

    public void marshall(VirtualInterface virtualInterface, StructuredJsonGenerator jsonGenerator) {
        if (virtualInterface == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList routeFilterPrefixesList;
            jsonGenerator.writeStartObject();
            if (virtualInterface.getOwnerAccount() != null) {
                jsonGenerator.writeFieldName("ownerAccount").writeValue(virtualInterface.getOwnerAccount());
            }
            if (virtualInterface.getVirtualInterfaceId() != null) {
                jsonGenerator.writeFieldName("virtualInterfaceId").writeValue(virtualInterface.getVirtualInterfaceId());
            }
            if (virtualInterface.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(virtualInterface.getLocation());
            }
            if (virtualInterface.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(virtualInterface.getConnectionId());
            }
            if (virtualInterface.getVirtualInterfaceType() != null) {
                jsonGenerator.writeFieldName("virtualInterfaceType").writeValue(virtualInterface.getVirtualInterfaceType());
            }
            if (virtualInterface.getVirtualInterfaceName() != null) {
                jsonGenerator.writeFieldName("virtualInterfaceName").writeValue(virtualInterface.getVirtualInterfaceName());
            }
            if (virtualInterface.getVlan() != null) {
                jsonGenerator.writeFieldName("vlan").writeValue(virtualInterface.getVlan());
            }
            if (virtualInterface.getAsn() != null) {
                jsonGenerator.writeFieldName("asn").writeValue(virtualInterface.getAsn());
            }
            if (virtualInterface.getAuthKey() != null) {
                jsonGenerator.writeFieldName("authKey").writeValue(virtualInterface.getAuthKey());
            }
            if (virtualInterface.getAmazonAddress() != null) {
                jsonGenerator.writeFieldName("amazonAddress").writeValue(virtualInterface.getAmazonAddress());
            }
            if (virtualInterface.getCustomerAddress() != null) {
                jsonGenerator.writeFieldName("customerAddress").writeValue(virtualInterface.getCustomerAddress());
            }
            if (virtualInterface.getVirtualInterfaceState() != null) {
                jsonGenerator.writeFieldName("virtualInterfaceState").writeValue(virtualInterface.getVirtualInterfaceState());
            }
            if (virtualInterface.getCustomerRouterConfig() != null) {
                jsonGenerator.writeFieldName("customerRouterConfig").writeValue(virtualInterface.getCustomerRouterConfig());
            }
            if (virtualInterface.getVirtualGatewayId() != null) {
                jsonGenerator.writeFieldName("virtualGatewayId").writeValue(virtualInterface.getVirtualGatewayId());
            }
            if (!(routeFilterPrefixesList = (SdkInternalList)virtualInterface.getRouteFilterPrefixes()).isEmpty() || !routeFilterPrefixesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("routeFilterPrefixes");
                jsonGenerator.writeStartArray();
                for (RouteFilterPrefix routeFilterPrefixesListValue : routeFilterPrefixesList) {
                    if (routeFilterPrefixesListValue == null) continue;
                    RouteFilterPrefixJsonMarshaller.getInstance().marshall(routeFilterPrefixesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VirtualInterfaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VirtualInterfaceJsonMarshaller();
        }
        return instance;
    }
}

