/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest;
import com.amazonaws.services.datapipeline.model.transform.FieldJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ReportTaskProgressRequestMarshaller
implements Marshaller<Request<ReportTaskProgressRequest>, ReportTaskProgressRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ReportTaskProgressRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ReportTaskProgressRequest> marshall(ReportTaskProgressRequest reportTaskProgressRequest) {
        if (reportTaskProgressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReportTaskProgressRequest> request = new DefaultRequest<ReportTaskProgressRequest>(reportTaskProgressRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.ReportTaskProgress");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList fieldsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (reportTaskProgressRequest.getTaskId() != null) {
                jsonGenerator.writeFieldName("taskId").writeValue(reportTaskProgressRequest.getTaskId());
            }
            if (!(fieldsList = (SdkInternalList)reportTaskProgressRequest.getFields()).isEmpty() || !fieldsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("fields");
                jsonGenerator.writeStartArray();
                for (Field fieldsListValue : fieldsList) {
                    if (fieldsListValue == null) continue;
                    FieldJsonMarshaller.getInstance().marshall(fieldsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

