/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.GlobalSignOutRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GlobalSignOutRequestMarshaller
implements Marshaller<Request<GlobalSignOutRequest>, GlobalSignOutRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GlobalSignOutRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GlobalSignOutRequest> marshall(GlobalSignOutRequest globalSignOutRequest) {
        if (globalSignOutRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GlobalSignOutRequest> request = new DefaultRequest<GlobalSignOutRequest>(globalSignOutRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.GlobalSignOut");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (globalSignOutRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(globalSignOutRequest.getAccessToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

