/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetIntegrationRequestMarshaller
implements Marshaller<Request<GetIntegrationRequest>, GetIntegrationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetIntegrationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetIntegrationRequest> marshall(GetIntegrationRequest getIntegrationRequest) {
        if (getIntegrationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetIntegrationRequest> request = new DefaultRequest<GetIntegrationRequest>(getIntegrationRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getIntegrationRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getIntegrationRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", getIntegrationRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getIntegrationRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", getIntegrationRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getIntegrationRequest.getHttpMethod()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

