/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.http.CompositeErrorCodeParser;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.internal.http.IonErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorCodeParser;
import com.amazonaws.protocol.json.IonFactory;
import com.amazonaws.protocol.json.SdkIonGenerator;
import com.amazonaws.protocol.json.SdkStructuredJsonFactory;
import com.amazonaws.protocol.json.SdkStructuredJsonFactoryImpl;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeIonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.ImmutableMapParameter;
import com.fasterxml.jackson.core.JsonFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import software.amazon.ion.IonSystem;
import software.amazon.ion.system.IonBinaryWriterBuilder;
import software.amazon.ion.system.IonSystemBuilder;

@SdkInternalApi
class SdkStructuredIonFactory {
    private static final IonSystem ION_SYSTEM = IonSystemBuilder.standard().build();
    private static final JsonFactory JSON_FACTORY = new IonFactory(ION_SYSTEM);
    private static final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> UNMARSHALLERS = new ImmutableMapParameter.Builder<Class<BigDecimal>, SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller>().put(BigDecimal.class, SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller.getInstance()).put(BigInteger.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.BigIntegerIonUnmarshaller.getInstance())).put(Boolean.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.BooleanIonUnmarshaller.getInstance())).put(ByteBuffer.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ByteBufferIonUnmarshaller.getInstance())).put(Byte.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ByteIonUnmarshaller.getInstance())).put(Date.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.DateIonUnmarshaller.getInstance())).put(Double.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.DoubleIonUnmarshaller.getInstance())).put(Float.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.FloatIonUnmarshaller.getInstance())).put(Integer.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.IntegerIonUnmarshaller.getInstance())).put(Long.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.LongIonUnmarshaller.getInstance())).put(Short.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.ShortIonUnmarshaller.getInstance())).put(String.class, (SimpleTypeIonUnmarshallers.BigDecimalIonUnmarshaller)((Object)SimpleTypeIonUnmarshallers.StringIonUnmarshaller.getInstance())).build();
    private static final IonBinaryWriterBuilder WRITER_BUILDER = IonBinaryWriterBuilder.standard().immutable();
    public static final SdkStructuredJsonFactory SDK_ION_FACTORY = new SdkStructuredJsonFactoryImpl(JSON_FACTORY, (Map)UNMARSHALLERS){

        @Override
        protected StructuredJsonGenerator createWriter(JsonFactory jsonFactory, String contentType) {
            return new SdkIonGenerator(WRITER_BUILDER, contentType);
        }

        @Override
        protected ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
            return new CompositeErrorCodeParser(new IonErrorCodeParser(ION_SYSTEM), new JsonErrorCodeParser(customErrorCodeFieldName));
        }
    };

    SdkStructuredIonFactory() {
    }
}

