/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.snowball.AmazonSnowball;
import com.amazonaws.services.snowball.model.AmazonSnowballException;
import com.amazonaws.services.snowball.model.CancelJobRequest;
import com.amazonaws.services.snowball.model.CancelJobResult;
import com.amazonaws.services.snowball.model.CreateAddressRequest;
import com.amazonaws.services.snowball.model.CreateAddressResult;
import com.amazonaws.services.snowball.model.CreateJobRequest;
import com.amazonaws.services.snowball.model.CreateJobResult;
import com.amazonaws.services.snowball.model.DescribeAddressRequest;
import com.amazonaws.services.snowball.model.DescribeAddressResult;
import com.amazonaws.services.snowball.model.DescribeAddressesRequest;
import com.amazonaws.services.snowball.model.DescribeAddressesResult;
import com.amazonaws.services.snowball.model.DescribeJobRequest;
import com.amazonaws.services.snowball.model.DescribeJobResult;
import com.amazonaws.services.snowball.model.GetJobManifestRequest;
import com.amazonaws.services.snowball.model.GetJobManifestResult;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeRequest;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeResult;
import com.amazonaws.services.snowball.model.GetSnowballUsageRequest;
import com.amazonaws.services.snowball.model.GetSnowballUsageResult;
import com.amazonaws.services.snowball.model.InvalidAddressException;
import com.amazonaws.services.snowball.model.InvalidJobStateException;
import com.amazonaws.services.snowball.model.InvalidResourceException;
import com.amazonaws.services.snowball.model.KMSRequestFailedException;
import com.amazonaws.services.snowball.model.ListJobsRequest;
import com.amazonaws.services.snowball.model.ListJobsResult;
import com.amazonaws.services.snowball.model.UnsupportedAddressException;
import com.amazonaws.services.snowball.model.UpdateJobRequest;
import com.amazonaws.services.snowball.model.UpdateJobResult;
import com.amazonaws.services.snowball.model.transform.CancelJobRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.CreateAddressRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.CreateAddressResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressesRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeAddressesResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.DescribeJobResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobManifestRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobManifestResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobUnlockCodeRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.GetJobUnlockCodeResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.GetSnowballUsageRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.GetSnowballUsageResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateJobRequestMarshaller;
import com.amazonaws.services.snowball.model.transform.UpdateJobResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonSnowballClient
extends AmazonWebServiceClient
implements AmazonSnowball {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSnowball.class);
    private static final String DEFAULT_SIGNING_NAME = "snowball";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAddressException").withModeledClass(UnsupportedAddressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobStateException").withModeledClass(InvalidJobStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceException").withModeledClass(InvalidResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSRequestFailedException").withModeledClass(KMSRequestFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAddressException").withModeledClass(InvalidAddressException.class)).withBaseServiceExceptionClass(AmazonSnowballException.class));

    public AmazonSnowballClient() {
        this(new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonSnowballClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSnowballClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonSnowballClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSnowballClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonSnowballClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSnowballClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AmazonSnowballClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("snowball.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/snowball/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/snowball/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobResult cancelJob(CancelJobRequest cancelJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(cancelJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CancelJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobResult cancelJobResult = (CancelJobResult)response.getAwsResponse();
            return cancelJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAddressResult createAddress(CreateAddressRequest createAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAddressRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAddressResult createAddressResult = (CreateAddressResult)response.getAwsResponse();
            return createAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResult createJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAddressResult describeAddress(DescribeAddressRequest describeAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAddressRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAddressResult describeAddressResult = (DescribeAddressResult)response.getAwsResponse();
            return describeAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAddressesResult describeAddresses(DescribeAddressesRequest describeAddressesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAddressesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAddressesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAddressesRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeAddressesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeAddressesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAddressesResult describeAddressesResult = (DescribeAddressesResult)response.getAwsResponse();
            return describeAddressesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResult describeJob(DescribeJobRequest describeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobResult describeJobResult = (DescribeJobResult)response.getAwsResponse();
            return describeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobManifestResult getJobManifest(GetJobManifestRequest getJobManifestRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobManifestRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobManifestRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobManifestRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getJobManifestRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetJobManifestResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobManifestResult getJobManifestResult = (GetJobManifestResult)response.getAwsResponse();
            return getJobManifestResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobUnlockCodeResult getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobUnlockCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobUnlockCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobUnlockCodeRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getJobUnlockCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetJobUnlockCodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobUnlockCodeResult getJobUnlockCodeResult = (GetJobUnlockCodeResult)response.getAwsResponse();
            return getJobUnlockCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnowballUsageResult getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSnowballUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSnowballUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSnowballUsageRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getSnowballUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSnowballUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSnowballUsageResult getSnowballUsageResult = (GetSnowballUsageResult)response.getAwsResponse();
            return getSnowballUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobResult updateJob(UpdateJobRequest updateJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobResult updateJobResult = (UpdateJobResult)response.getAwsResponse();
            return updateJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

