/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.AssessmentRunAgent;
import com.amazonaws.services.inspector.model.TelemetryMetadata;
import com.amazonaws.services.inspector.model.transform.TelemetryMetadataJsonMarshaller;
import java.util.List;

public class AssessmentRunAgentJsonMarshaller {
    private static AssessmentRunAgentJsonMarshaller instance;

    public void marshall(AssessmentRunAgent assessmentRunAgent, StructuredJsonGenerator jsonGenerator) {
        if (assessmentRunAgent == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<TelemetryMetadata> telemetryMetadataList;
            jsonGenerator.writeStartObject();
            if (assessmentRunAgent.getAgentId() != null) {
                jsonGenerator.writeFieldName("agentId").writeValue(assessmentRunAgent.getAgentId());
            }
            if (assessmentRunAgent.getAssessmentRunArn() != null) {
                jsonGenerator.writeFieldName("assessmentRunArn").writeValue(assessmentRunAgent.getAssessmentRunArn());
            }
            if (assessmentRunAgent.getAgentHealth() != null) {
                jsonGenerator.writeFieldName("agentHealth").writeValue(assessmentRunAgent.getAgentHealth());
            }
            if (assessmentRunAgent.getAgentHealthCode() != null) {
                jsonGenerator.writeFieldName("agentHealthCode").writeValue(assessmentRunAgent.getAgentHealthCode());
            }
            if (assessmentRunAgent.getAgentHealthDetails() != null) {
                jsonGenerator.writeFieldName("agentHealthDetails").writeValue(assessmentRunAgent.getAgentHealthDetails());
            }
            if (assessmentRunAgent.getAutoScalingGroup() != null) {
                jsonGenerator.writeFieldName("autoScalingGroup").writeValue(assessmentRunAgent.getAutoScalingGroup());
            }
            if ((telemetryMetadataList = assessmentRunAgent.getTelemetryMetadata()) != null) {
                jsonGenerator.writeFieldName("telemetryMetadata");
                jsonGenerator.writeStartArray();
                for (TelemetryMetadata telemetryMetadataListValue : telemetryMetadataList) {
                    if (telemetryMetadataListValue == null) continue;
                    TelemetryMetadataJsonMarshaller.getInstance().marshall(telemetryMetadataListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentRunAgentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentRunAgentJsonMarshaller();
        }
        return instance;
    }
}

