/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupDetail;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesDetail;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupDetailJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.PlacementTypeJsonMarshaller;

public class JobFlowInstancesDetailJsonMarshaller {
    private static JobFlowInstancesDetailJsonMarshaller instance;

    public void marshall(JobFlowInstancesDetail jobFlowInstancesDetail, StructuredJsonGenerator jsonGenerator) {
        if (jobFlowInstancesDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList instanceGroupsList;
            jsonGenerator.writeStartObject();
            if (jobFlowInstancesDetail.getMasterInstanceType() != null) {
                jsonGenerator.writeFieldName("MasterInstanceType").writeValue(jobFlowInstancesDetail.getMasterInstanceType());
            }
            if (jobFlowInstancesDetail.getMasterPublicDnsName() != null) {
                jsonGenerator.writeFieldName("MasterPublicDnsName").writeValue(jobFlowInstancesDetail.getMasterPublicDnsName());
            }
            if (jobFlowInstancesDetail.getMasterInstanceId() != null) {
                jsonGenerator.writeFieldName("MasterInstanceId").writeValue(jobFlowInstancesDetail.getMasterInstanceId());
            }
            if (jobFlowInstancesDetail.getSlaveInstanceType() != null) {
                jsonGenerator.writeFieldName("SlaveInstanceType").writeValue(jobFlowInstancesDetail.getSlaveInstanceType());
            }
            if (jobFlowInstancesDetail.getInstanceCount() != null) {
                jsonGenerator.writeFieldName("InstanceCount").writeValue(jobFlowInstancesDetail.getInstanceCount());
            }
            if (!(instanceGroupsList = (SdkInternalList)jobFlowInstancesDetail.getInstanceGroups()).isEmpty() || !instanceGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceGroups");
                jsonGenerator.writeStartArray();
                for (InstanceGroupDetail instanceGroupsListValue : instanceGroupsList) {
                    if (instanceGroupsListValue == null) continue;
                    InstanceGroupDetailJsonMarshaller.getInstance().marshall(instanceGroupsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (jobFlowInstancesDetail.getNormalizedInstanceHours() != null) {
                jsonGenerator.writeFieldName("NormalizedInstanceHours").writeValue(jobFlowInstancesDetail.getNormalizedInstanceHours());
            }
            if (jobFlowInstancesDetail.getEc2KeyName() != null) {
                jsonGenerator.writeFieldName("Ec2KeyName").writeValue(jobFlowInstancesDetail.getEc2KeyName());
            }
            if (jobFlowInstancesDetail.getEc2SubnetId() != null) {
                jsonGenerator.writeFieldName("Ec2SubnetId").writeValue(jobFlowInstancesDetail.getEc2SubnetId());
            }
            if (jobFlowInstancesDetail.getPlacement() != null) {
                jsonGenerator.writeFieldName("Placement");
                PlacementTypeJsonMarshaller.getInstance().marshall(jobFlowInstancesDetail.getPlacement(), jsonGenerator);
            }
            if (jobFlowInstancesDetail.getKeepJobFlowAliveWhenNoSteps() != null) {
                jsonGenerator.writeFieldName("KeepJobFlowAliveWhenNoSteps").writeValue(jobFlowInstancesDetail.getKeepJobFlowAliveWhenNoSteps());
            }
            if (jobFlowInstancesDetail.getTerminationProtected() != null) {
                jsonGenerator.writeFieldName("TerminationProtected").writeValue(jobFlowInstancesDetail.getTerminationProtected());
            }
            if (jobFlowInstancesDetail.getHadoopVersion() != null) {
                jsonGenerator.writeFieldName("HadoopVersion").writeValue(jobFlowInstancesDetail.getHadoopVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobFlowInstancesDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobFlowInstancesDetailJsonMarshaller();
        }
        return instance;
    }
}

