/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.NetworkBinding;
import com.amazonaws.services.ecs.model.transform.NetworkBindingJsonMarshaller;

public class ContainerJsonMarshaller {
    private static ContainerJsonMarshaller instance;

    public void marshall(Container container, StructuredJsonGenerator jsonGenerator) {
        if (container == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList networkBindingsList;
            jsonGenerator.writeStartObject();
            if (container.getContainerArn() != null) {
                jsonGenerator.writeFieldName("containerArn").writeValue(container.getContainerArn());
            }
            if (container.getTaskArn() != null) {
                jsonGenerator.writeFieldName("taskArn").writeValue(container.getTaskArn());
            }
            if (container.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(container.getName());
            }
            if (container.getLastStatus() != null) {
                jsonGenerator.writeFieldName("lastStatus").writeValue(container.getLastStatus());
            }
            if (container.getExitCode() != null) {
                jsonGenerator.writeFieldName("exitCode").writeValue(container.getExitCode());
            }
            if (container.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(container.getReason());
            }
            if (!(networkBindingsList = (SdkInternalList)container.getNetworkBindings()).isEmpty() || !networkBindingsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("networkBindings");
                jsonGenerator.writeStartArray();
                for (NetworkBinding networkBindingsListValue : networkBindingsList) {
                    if (networkBindingsListValue == null) continue;
                    NetworkBindingJsonMarshaller.getInstance().marshall(networkBindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerJsonMarshaller();
        }
        return instance;
    }
}

