/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.util.BinaryUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.Timestamp;
import software.amazon.ion.system.IonBinaryWriterBuilder;

class SdkIonGenerator
implements StructuredJsonGenerator {
    private final String contentType;
    private final ByteArrayOutputStream bytes;
    private final IonWriter writer;

    public SdkIonGenerator(IonBinaryWriterBuilder writerBuilder, String contentType) {
        this.contentType = contentType;
        this.bytes = new ByteArrayOutputStream();
        this.writer = writerBuilder.build((OutputStream)this.bytes);
    }

    @Override
    public StructuredJsonGenerator writeStartArray() {
        try {
            this.writer.stepIn(IonType.LIST);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndArray() {
        try {
            this.writer.stepOut();
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeStartObject() {
        try {
            this.writer.stepIn(IonType.STRUCT);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndObject() {
        try {
            this.writer.stepOut();
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeFieldName(String fieldName) {
        this.writer.setFieldName(fieldName);
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(String val) {
        try {
            this.writer.writeString(val);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(boolean bool) {
        try {
            this.writer.writeBool(bool);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(long val) {
        try {
            this.writer.writeInt(val);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(double val) {
        try {
            this.writer.writeFloat(val);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(float val) {
        try {
            this.writer.writeFloat((double)val);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(short val) {
        try {
            this.writer.writeInt((long)val);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(int val) {
        try {
            this.writer.writeInt((long)val);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(ByteBuffer bytes) {
        try {
            this.writer.writeBlob(BinaryUtils.copyAllBytesFrom(bytes));
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(Date date) {
        try {
            this.writer.writeTimestamp(Timestamp.forDateZ((Date)date));
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigDecimal value) {
        try {
            this.writer.writeDecimal(value);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigInteger value) {
        try {
            this.writer.writeInt(value);
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this;
    }

    @Override
    public byte[] getBytes() {
        try {
            this.writer.finish();
        }
        catch (IOException e) {
            throw new AmazonClientException(e);
        }
        return this.bytes.toByteArray();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

