/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.NotificationEvent;
import com.amazonaws.services.simplesystemsmanagement.model.NotificationType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class NotificationConfig
implements Serializable,
Cloneable {
    private String notificationArn;
    private SdkInternalList<String> notificationEvents;
    private String notificationType;

    public void setNotificationArn(String notificationArn) {
        this.notificationArn = notificationArn;
    }

    public String getNotificationArn() {
        return this.notificationArn;
    }

    public NotificationConfig withNotificationArn(String notificationArn) {
        this.setNotificationArn(notificationArn);
        return this;
    }

    public List<String> getNotificationEvents() {
        if (this.notificationEvents == null) {
            this.notificationEvents = new SdkInternalList();
        }
        return this.notificationEvents;
    }

    public void setNotificationEvents(Collection<String> notificationEvents) {
        if (notificationEvents == null) {
            this.notificationEvents = null;
            return;
        }
        this.notificationEvents = new SdkInternalList<String>(notificationEvents);
    }

    public NotificationConfig withNotificationEvents(String ... notificationEvents) {
        if (this.notificationEvents == null) {
            this.setNotificationEvents(new SdkInternalList<String>(notificationEvents.length));
        }
        for (String ele : notificationEvents) {
            this.notificationEvents.add(ele);
        }
        return this;
    }

    public NotificationConfig withNotificationEvents(Collection<String> notificationEvents) {
        this.setNotificationEvents(notificationEvents);
        return this;
    }

    public NotificationConfig withNotificationEvents(NotificationEvent ... notificationEvents) {
        SdkInternalList<String> notificationEventsCopy = new SdkInternalList<String>(notificationEvents.length);
        for (NotificationEvent value : notificationEvents) {
            notificationEventsCopy.add(value.toString());
        }
        if (this.getNotificationEvents() == null) {
            this.setNotificationEvents(notificationEventsCopy);
        } else {
            this.getNotificationEvents().addAll(notificationEventsCopy);
        }
        return this;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public NotificationConfig withNotificationType(String notificationType) {
        this.setNotificationType(notificationType);
        return this;
    }

    public void setNotificationType(NotificationType notificationType) {
        this.notificationType = notificationType.toString();
    }

    public NotificationConfig withNotificationType(NotificationType notificationType) {
        this.setNotificationType(notificationType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNotificationArn() != null) {
            sb.append("NotificationArn: " + this.getNotificationArn() + ",");
        }
        if (this.getNotificationEvents() != null) {
            sb.append("NotificationEvents: " + this.getNotificationEvents() + ",");
        }
        if (this.getNotificationType() != null) {
            sb.append("NotificationType: " + this.getNotificationType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig other = (NotificationConfig)obj;
        if (other.getNotificationArn() == null ^ this.getNotificationArn() == null) {
            return false;
        }
        if (other.getNotificationArn() != null && !other.getNotificationArn().equals(this.getNotificationArn())) {
            return false;
        }
        if (other.getNotificationEvents() == null ^ this.getNotificationEvents() == null) {
            return false;
        }
        if (other.getNotificationEvents() != null && !other.getNotificationEvents().equals(this.getNotificationEvents())) {
            return false;
        }
        if (other.getNotificationType() == null ^ this.getNotificationType() == null) {
            return false;
        }
        return other.getNotificationType() == null || other.getNotificationType().equals(this.getNotificationType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNotificationArn() == null ? 0 : this.getNotificationArn().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationEvents() == null ? 0 : this.getNotificationEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationType() == null ? 0 : this.getNotificationType().hashCode());
        return hashCode;
    }

    public NotificationConfig clone() {
        try {
            return (NotificationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

