/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.SetTaskStatusRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SetTaskStatusRequestMarshaller
implements Marshaller<Request<SetTaskStatusRequest>, SetTaskStatusRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetTaskStatusRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SetTaskStatusRequest> marshall(SetTaskStatusRequest setTaskStatusRequest) {
        if (setTaskStatusRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetTaskStatusRequest> request = new DefaultRequest<SetTaskStatusRequest>(setTaskStatusRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.SetTaskStatus");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (setTaskStatusRequest.getTaskId() != null) {
                jsonGenerator.writeFieldName("taskId").writeValue(setTaskStatusRequest.getTaskId());
            }
            if (setTaskStatusRequest.getTaskStatus() != null) {
                jsonGenerator.writeFieldName("taskStatus").writeValue(setTaskStatusRequest.getTaskStatus());
            }
            if (setTaskStatusRequest.getErrorId() != null) {
                jsonGenerator.writeFieldName("errorId").writeValue(setTaskStatusRequest.getErrorId());
            }
            if (setTaskStatusRequest.getErrorMessage() != null) {
                jsonGenerator.writeFieldName("errorMessage").writeValue(setTaskStatusRequest.getErrorMessage());
            }
            if (setTaskStatusRequest.getErrorStackTrace() != null) {
                jsonGenerator.writeFieldName("errorStackTrace").writeValue(setTaskStatusRequest.getErrorStackTrace());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

