/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.HealthCheck;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListHealthChecksResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<HealthCheck> healthChecks;
    private String marker;
    private Boolean isTruncated;
    private String nextMarker;
    private String maxItems;

    public List<HealthCheck> getHealthChecks() {
        if (this.healthChecks == null) {
            this.healthChecks = new SdkInternalList();
        }
        return this.healthChecks;
    }

    public void setHealthChecks(Collection<HealthCheck> healthChecks) {
        if (healthChecks == null) {
            this.healthChecks = null;
            return;
        }
        this.healthChecks = new SdkInternalList<HealthCheck>(healthChecks);
    }

    public ListHealthChecksResult withHealthChecks(HealthCheck ... healthChecks) {
        if (this.healthChecks == null) {
            this.setHealthChecks(new SdkInternalList<HealthCheck>(healthChecks.length));
        }
        for (HealthCheck ele : healthChecks) {
            this.healthChecks.add(ele);
        }
        return this;
    }

    public ListHealthChecksResult withHealthChecks(Collection<HealthCheck> healthChecks) {
        this.setHealthChecks(healthChecks);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListHealthChecksResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public ListHealthChecksResult withIsTruncated(Boolean isTruncated) {
        this.setIsTruncated(isTruncated);
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListHealthChecksResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public void setMaxItems(String maxItems) {
        this.maxItems = maxItems;
    }

    public String getMaxItems() {
        return this.maxItems;
    }

    public ListHealthChecksResult withMaxItems(String maxItems) {
        this.setMaxItems(maxItems);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHealthChecks() != null) {
            sb.append("HealthChecks: " + this.getHealthChecks() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getIsTruncated() != null) {
            sb.append("IsTruncated: " + this.getIsTruncated() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: " + this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksResult)) {
            return false;
        }
        ListHealthChecksResult other = (ListHealthChecksResult)obj;
        if (other.getHealthChecks() == null ^ this.getHealthChecks() == null) {
            return false;
        }
        if (other.getHealthChecks() != null && !other.getHealthChecks().equals(this.getHealthChecks())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getIsTruncated() == null ^ this.getIsTruncated() == null) {
            return false;
        }
        if (other.getIsTruncated() != null && !other.getIsTruncated().equals(this.getIsTruncated())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHealthChecks() == null ? 0 : this.getHealthChecks().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getIsTruncated() == null ? 0 : this.getIsTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public ListHealthChecksResult clone() {
        try {
            return (ListHealthChecksResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

