/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputRequest;
import com.amazonaws.services.kinesisanalytics.model.transform.InputJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AddApplicationInputRequestMarshaller
implements Marshaller<Request<AddApplicationInputRequest>, AddApplicationInputRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AddApplicationInputRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AddApplicationInputRequest> marshall(AddApplicationInputRequest addApplicationInputRequest) {
        if (addApplicationInputRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddApplicationInputRequest> request = new DefaultRequest<AddApplicationInputRequest>(addApplicationInputRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.AddApplicationInput");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addApplicationInputRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(addApplicationInputRequest.getApplicationName());
            }
            if (addApplicationInputRequest.getCurrentApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentApplicationVersionId").writeValue(addApplicationInputRequest.getCurrentApplicationVersionId());
            }
            if (addApplicationInputRequest.getInput() != null) {
                jsonGenerator.writeFieldName("Input");
                InputJsonMarshaller.getInstance().marshall(addApplicationInputRequest.getInput(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

