/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionType;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class StandardModelFactories {
    private static final Log LOG = LogFactory.getLog(StandardModelFactories.class);
    static final Converter<AttributeValue> CopyConverter = new Converter<AttributeValue>(DynamoDBMapperFieldModel.DynamoDBAttributeType.NULL){

        @Override
        public AttributeValue get(AttributeValue o) {
            return o == null ? null : super.convert(o);
        }

        @Override
        public void set(AttributeValue value, AttributeValue o) {
            value.withS(o.getS()).withN(o.getN()).withB(o.getB()).withSS(o.getSS()).withNS(o.getNS()).withBS(o.getBS()).withBOOL(o.getBOOL()).withL(o.getL()).withM(o.getM()).withNULL(o.getNULL());
        }
    };
    private static final Converter<String> S = new Converter<String>(DynamoDBMapperFieldModel.DynamoDBAttributeType.S){

        @Override
        public String get(AttributeValue value) {
            return value.getS();
        }

        @Override
        public void set(AttributeValue value, String o) {
            value.setS(o);
        }

        @Override
        public AttributeValue convert(String o) {
            return o.length() == 0 ? null : super.convert(o);
        }
    };
    private static final Converter<String> N = new Converter<String>(DynamoDBMapperFieldModel.DynamoDBAttributeType.N){

        @Override
        public String get(AttributeValue value) {
            return value.getN();
        }

        @Override
        public void set(AttributeValue value, String o) {
            value.setN(o);
        }
    };
    private static final Converter<ByteBuffer> B = new Converter<ByteBuffer>(DynamoDBMapperFieldModel.DynamoDBAttributeType.B){

        @Override
        public ByteBuffer get(AttributeValue value) {
            return value.getB();
        }

        @Override
        public void set(AttributeValue value, ByteBuffer o) {
            value.setB(o);
        }
    };
    private static final Converter<List<String>> SS = new Converter<List<String>>(DynamoDBMapperFieldModel.DynamoDBAttributeType.SS){

        @Override
        public List<String> get(AttributeValue value) {
            return value.getSS();
        }

        @Override
        public void set(AttributeValue value, List<String> o) {
            value.setSS(o);
        }
    };
    private static final Converter<List<String>> NS = new Converter<List<String>>(DynamoDBMapperFieldModel.DynamoDBAttributeType.NS){

        @Override
        public List<String> get(AttributeValue value) {
            return value.getNS();
        }

        @Override
        public void set(AttributeValue value, List<String> o) {
            value.setNS(o);
        }
    };
    private static final Converter<List<ByteBuffer>> BS = new Converter<List<ByteBuffer>>(DynamoDBMapperFieldModel.DynamoDBAttributeType.BS){

        @Override
        public List<ByteBuffer> get(AttributeValue value) {
            return value.getBS();
        }

        @Override
        public void set(AttributeValue value, List<ByteBuffer> o) {
            value.setBS(o);
        }
    };
    private static final Converter<Boolean> BOOL = new Converter<Boolean>(DynamoDBMapperFieldModel.DynamoDBAttributeType.BOOL){

        @Override
        public Boolean get(AttributeValue o) {
            return o.getBOOL();
        }

        @Override
        public void set(AttributeValue o, Boolean value) {
            o.setBOOL(value);
        }

        @Override
        public Boolean unconvert(AttributeValue o) {
            if (o.getBOOL() == null && o.getN() != null) {
                return (Boolean)StandardTypeConverters.Scalar.BOOLEAN.convert(o.getN());
            }
            return (Boolean)super.unconvert(o);
        }
    };
    private static final Converter<List<AttributeValue>> L = new Converter<List<AttributeValue>>(DynamoDBMapperFieldModel.DynamoDBAttributeType.L){

        @Override
        public List<AttributeValue> get(AttributeValue value) {
            return value.getL();
        }

        @Override
        public void set(AttributeValue value, List<AttributeValue> o) {
            value.setL(o);
        }
    };
    private static final Converter<Map<String, AttributeValue>> M = new Converter<Map<String, AttributeValue>>(DynamoDBMapperFieldModel.DynamoDBAttributeType.M){

        @Override
        public Map<String, AttributeValue> get(AttributeValue value) {
            return value.getM();
        }

        @Override
        public void set(AttributeValue value, Map<String, AttributeValue> o) {
            value.setM(o);
        }
    };

    StandardModelFactories() {
    }

    static final DynamoDBMapperModelFactory.Factory of(S3Link.Factory s3Links) {
        return new ConversionSchemaFactory(s3Links);
    }

    private static final <T> RuleFactory<T> rulesOf(DynamoDBMapperConfig config, S3Link.Factory s3Links, DynamoDBMapperModelFactory.Factory models) {
        Rules factory = new Rules(config.getTypeConverterFactory().override().with(String.class, S3Link.class, s3Links).build());
        if (config.getConversionSchema() == ConversionSchemas.V1) {
            Rules rules = factory;
            rules.getClass();
            factory.with(rules.new Rules.NativeBool(true));
            Rules rules2 = factory;
            rules2.getClass();
            factory.with(rules2.new Rules.SimpleScalar(String.class, StandardModelFactories.S));
            Rules rules3 = factory;
            rules3.getClass();
            factory.with(rules3.new Rules.SimpleScalar(String.class, StandardModelFactories.N));
            Rules rules4 = factory;
            rules4.getClass();
            factory.with(rules4.new Rules.SimpleScalar(ByteBuffer.class, StandardModelFactories.B));
            Rules rules5 = factory;
            rules5.getClass();
            factory.with(rules5.new Rules.SimpleScalarSet(String.class, StandardModelFactories.SS));
            Rules rules6 = factory;
            rules6.getClass();
            factory.with(rules6.new Rules.SimpleScalarSet(String.class, StandardModelFactories.NS));
            Rules rules7 = factory;
            rules7.getClass();
            factory.with(rules7.new Rules.SimpleScalarSet(ByteBuffer.class, StandardModelFactories.BS));
            Rules rules8 = factory;
            rules8.getClass();
            factory.with(rules8.new Rules.ObjectStringSet());
        } else if (config.getConversionSchema() == ConversionSchemas.V2) {
            Rules rules = factory;
            rules.getClass();
            factory.with(rules.new Rules.NativeTyped());
            Rules rules9 = factory;
            rules9.getClass();
            factory.with(rules9.new Rules.NativeBool(false));
            Rules rules10 = factory;
            rules10.getClass();
            factory.with(rules10.new Rules.SimpleScalar(String.class, StandardModelFactories.S));
            Rules rules11 = factory;
            rules11.getClass();
            factory.with(rules11.new Rules.SimpleScalar(String.class, StandardModelFactories.N));
            Rules rules12 = factory;
            rules12.getClass();
            factory.with(rules12.new Rules.SimpleScalar(ByteBuffer.class, StandardModelFactories.B));
            Rules rules13 = factory;
            rules13.getClass();
            factory.with(rules13.new Rules.NativeBoolSet());
            Rules rules14 = factory;
            rules14.getClass();
            factory.with(rules14.new Rules.SimpleScalarSet(String.class, StandardModelFactories.SS));
            Rules rules15 = factory;
            rules15.getClass();
            factory.with(rules15.new Rules.SimpleScalarSet(String.class, StandardModelFactories.NS));
            Rules rules16 = factory;
            rules16.getClass();
            factory.with(rules16.new Rules.SimpleScalarSet(ByteBuffer.class, StandardModelFactories.BS));
            Rules rules17 = factory;
            rules17.getClass();
            factory.with(rules17.new Rules.ObjectSet());
            Rules rules18 = factory;
            rules18.getClass();
            factory.with(rules18.new Rules.ObjectList());
            Rules rules19 = factory;
            rules19.getClass();
            factory.with(rules19.new Rules.ObjectMap());
            Rules rules20 = factory;
            rules20.getClass();
            factory.with(rules20.new Rules.ObjectDocumentMap(models, config));
        } else {
            Rules rules = factory;
            rules.getClass();
            factory.with(rules.new Rules.NativeTyped());
            Rules rules21 = factory;
            rules21.getClass();
            factory.with(rules21.new Rules.NativeBool(true));
            Rules rules22 = factory;
            rules22.getClass();
            factory.with(rules22.new Rules.SimpleScalar(String.class, StandardModelFactories.S));
            Rules rules23 = factory;
            rules23.getClass();
            factory.with(rules23.new Rules.SimpleScalar(String.class, StandardModelFactories.N));
            Rules rules24 = factory;
            rules24.getClass();
            factory.with(rules24.new Rules.SimpleScalar(ByteBuffer.class, StandardModelFactories.B));
            Rules rules25 = factory;
            rules25.getClass();
            factory.with(rules25.new Rules.SimpleScalarSet(String.class, StandardModelFactories.SS));
            Rules rules26 = factory;
            rules26.getClass();
            factory.with(rules26.new Rules.SimpleScalarSet(String.class, StandardModelFactories.NS));
            Rules rules27 = factory;
            rules27.getClass();
            factory.with(rules27.new Rules.SimpleScalarSet(ByteBuffer.class, StandardModelFactories.BS));
            Rules rules28 = factory;
            rules28.getClass();
            factory.with(rules28.new Rules.ObjectStringSet());
            Rules rules29 = factory;
            rules29.getClass();
            factory.with(rules29.new Rules.ObjectList());
            Rules rules30 = factory;
            rules30.getClass();
            factory.with(rules30.new Rules.ObjectMap());
            Rules rules31 = factory;
            rules31.getClass();
            factory.with(rules31.new Rules.ObjectDocumentMap(models, config));
        }
        return factory;
    }

    static abstract class Converter<S>
    extends DynamoDBTypeConverter.AbstractConverter<AttributeValue, S>
    implements DynamoDBMapperFieldModel.Reflect<AttributeValue, S> {
        private final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType;

        private Converter(DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType) {
            this.attributeType = attributeType;
        }

        public DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
            return this.attributeType;
        }

        @Override
        public AttributeValue convert(S o) {
            AttributeValue value = new AttributeValue();
            this.set(value, o);
            return value;
        }

        @Override
        public S unconvert(AttributeValue o) {
            Object value = this.get(o);
            if (value == null && o.isNULL() == null) {
                throw new DynamoDBMappingException("expected " + (Object)((Object)this.attributeType()) + " in value " + o);
            }
            return (S)value;
        }
    }

    static interface RuleFactory<T> {
        public Rule<T> getRule(ConversionType<T> var1);
    }

    static interface Rule<T> {
        public boolean isAssignableFrom(ConversionType<?> var1);

        public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConversionType<T> var1);

        public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType();
    }

    private static final class Rules<T>
    implements RuleFactory<T> {
        private final Set<Rule<T>> rules = new LinkedHashSet<Rule<T>>();
        private final DynamoDBTypeConverterFactory scalars;

        private Rules(DynamoDBTypeConverterFactory scalars) {
            this.scalars = scalars;
        }

        private Rules<T> with(Rule<?> rule) {
            this.rules.add(rule);
            return this;
        }

        @Override
        public Rule<T> getRule(ConversionType<T> type) {
            for (Rule<T> rule : this.rules) {
                if (!rule.isAssignableFrom(type)) continue;
                return rule;
            }
            return new NotSupported();
        }

        private <S> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, ConversionType<T> type) {
            return this.scalars.getConverter(sourceType, type.targetType());
        }

        private DynamoDBTypeConverter<AttributeValue, T> getConverter(ConversionType<T> type) {
            return new DynamoDBTypeConverter.DelegateConverter<AttributeValue, T>(this.getRule(type).newConverter(type)){

                @Override
                public final AttributeValue convert(T o) {
                    return o == null ? new AttributeValue().withNULL(true) : (AttributeValue)super.convert(o);
                }
            };
        }

        private final class NotSupported
        implements Rule<T> {
            private NotSupported() {
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(final ConversionType<T> type) {
                return new DynamoDBTypeConverter<AttributeValue, T>(){

                    @Override
                    public final AttributeValue convert(T o) {
                        throw new DynamoDBMappingException("type " + type + " is not supported; requires @DynamoDBTyped or @DynamoDBTypeConverted");
                    }

                    @Override
                    public final T unconvert(AttributeValue o) {
                        throw new DynamoDBMappingException("type " + type + " is not supported; requires @DynamoDBTyped or @DynamoDBTypeConverted");
                    }
                };
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return DynamoDBMapperFieldModel.DynamoDBAttributeType.NULL;
            }
        }

        private final class ObjectDocumentMap
        implements Rule<T> {
            private final DynamoDBMapperModelFactory.Factory models;
            private final DynamoDBMapperConfig config;

            private ObjectDocumentMap(DynamoDBMapperModelFactory.Factory models, DynamoDBMapperConfig config) {
                this.models = models;
                this.config = config;
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return type.attributeType() == M.attributeType() && !StandardTypeConverters.Vector.MAP.is(type.targetType());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(final ConversionType<T> type) {
                return type.join(M.join(new DynamoDBTypeConverter<Map<String, AttributeValue>, T>(){

                    @Override
                    public final Map<String, AttributeValue> convert(T o) {
                        return ObjectDocumentMap.this.models.getModelFactory(ObjectDocumentMap.this.config).getTableModel(type.targetType()).convert(o);
                    }

                    @Override
                    public final T unconvert(Map<String, AttributeValue> o) {
                        return ObjectDocumentMap.this.models.getModelFactory(ObjectDocumentMap.this.config).getTableModel(type.targetType()).unconvert(o);
                    }
                }));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return M.attributeType();
            }
        }

        private final class ObjectMap
        implements Rule<Map<String, T>> {
            private ObjectMap() {
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return (type.attributeType() == M.attributeType() || type.attributeType() == null) && StandardTypeConverters.Vector.MAP.is(type.targetType()) && type.param(1) != null && StandardTypeConverters.Scalar.STRING.is(type.param(0).targetType());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Map<String, T>> newConverter(ConversionType<Map<String, T>> type) {
                return type.join(M.join(StandardTypeConverters.Vector.MAP.join(Rules.this.getConverter(type.param(1)))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return M.attributeType();
            }
        }

        private final class ObjectList
        implements Rule<List<T>> {
            private ObjectList() {
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return (type.attributeType() == L.attributeType() || type.attributeType() == null) && StandardTypeConverters.Vector.LIST.is(type.targetType()) && type.param(0) != null;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, List<T>> newConverter(ConversionType<List<T>> type) {
                return type.join(L.join(StandardTypeConverters.Vector.LIST.join(Rules.this.getConverter(type.param(0)))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return L.attributeType();
            }
        }

        private final class ObjectSet
        implements Rule<Collection<T>> {
            private ObjectSet() {
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return (type.attributeType() == L.attributeType() || type.attributeType() == null) && StandardTypeConverters.Vector.SET.is(type.targetType()) && type.param(0) != null;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConversionType<Collection<T>> type) {
                return type.join(L.join(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(type.param(0)))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return L.attributeType();
            }
        }

        private final class NativeBoolSet
        implements Rule<Collection<T>> {
            private NativeBoolSet() {
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return (type.attributeType() == L.attributeType() || type.attributeType() == null) && StandardTypeConverters.Vector.SET.is(type.targetType()) && type.param(0) != null && StandardTypeConverters.Scalar.BOOLEAN.is(type.param(0).targetType());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConversionType<Collection<T>> type) {
                final DynamoDBTypeConverter toBool = BOOL.join(Rules.this.scalars.getConverter(Boolean.class, String.class));
                return type.join(new DynamoDBTypeConverter.DelegateConverter<AttributeValue, List<AttributeValue>>((DynamoDBTypeConverter)L){

                    @Override
                    public List<AttributeValue> unconvert(AttributeValue o) {
                        return o.getL() == null && o.getNS() != null ? StandardTypeConverters.Vector.LIST.convert(o.getNS(), toBool) : (List)super.unconvert(o);
                    }
                }.join(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(type.param(0)))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return L.attributeType();
            }
        }

        private final class NativeBool
        implements Rule<T> {
            private final boolean onlyIfOverride;

            private NativeBool(boolean onlyIfOverride) {
                this.onlyIfOverride = onlyIfOverride;
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return type.attributeType() == BOOL.attributeType() || type.attributeType() == null && !this.onlyIfOverride && StandardTypeConverters.Scalar.BOOLEAN.is(type.targetType());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConversionType<T> type) {
                return type.join(BOOL.join(Rules.this.getConverter(Boolean.class, type)));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return BOOL.attributeType();
            }
        }

        private final class ObjectStringSet
        implements Rule<Collection<Object>> {
            private ObjectStringSet() {
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return type.attributeType() == null && StandardTypeConverters.Vector.SET.is(type.targetType());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<Object>> newConverter(ConversionType<Collection<Object>> type) {
                LOG.warn((Object)"Marshaling a set of non-String objects to a DynamoDB StringSet. You won't be able to read these objects back out of DynamoDB unless you REALLY know what you're doing: it's probably a bug. If you DO know what you're doing feelfree to ignore this warning, but consider using a custom marshaler for this instead.");
                return type.join(SS.join(StandardTypeConverters.Vector.SET.join(Rules.this.scalars.getConverter(String.class, Object.class))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return SS.attributeType();
            }
        }

        private final class SimpleScalarSet<S>
        implements Rule<Collection<T>> {
            private final ScalarAttributeType scalarAttributeType;
            private final Converter<List<S>> source;
            private final Class<S> sourceType;

            private SimpleScalarSet(Class<S> sourceType, Converter<List<S>> source) {
                this.scalarAttributeType = ScalarAttributeType.valueOf(((Converter)source).attributeType.name().substring(0, 1));
                this.sourceType = sourceType;
                this.source = source;
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return type.attributeType() == this.source.attributeType() || type.attributeType() == null && StandardTypeConverters.Vector.SET.is(type.targetType()) && type.param(0) != null && StandardTypeConverters.Scalar.of(type.param(0).targetType()).is(this.scalarAttributeType);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<T>> newConverter(ConversionType<Collection<T>> type) {
                return type.join(this.source.join(StandardTypeConverters.Vector.SET.join(Rules.this.getConverter(this.sourceType, type.param(0)))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.source.attributeType();
            }
        }

        private final class SimpleScalar<S>
        implements Rule<T> {
            private final ScalarAttributeType scalarAttributeType;
            private final Converter<S> source;
            private final Class<S> sourceType;

            private SimpleScalar(Class<S> sourceType, Converter<S> source) {
                this.scalarAttributeType = ScalarAttributeType.valueOf(((Converter)source).attributeType.name());
                this.sourceType = sourceType;
                this.source = source;
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return type.attributeType() == this.source.attributeType() || type.attributeType() == null && StandardTypeConverters.Scalar.of(type.targetType()).is(this.scalarAttributeType);
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> newConverter(ConversionType<T> type) {
                return type.join(this.source.join(Rules.this.getConverter(this.sourceType, type)));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.source.attributeType();
            }
        }

        private final class NativeTyped
        implements Rule<AttributeValue> {
            private NativeTyped() {
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return AttributeValue.class.isAssignableFrom(type.targetType());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, AttributeValue> newConverter(ConversionType<AttributeValue> type) {
                return type.join(CopyConverter);
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return DynamoDBMapperFieldModel.DynamoDBAttributeType.NULL;
            }
        }
    }

    private static final class FieldModelBuilder<T, V>
    extends DynamoDBMapperFieldModel.Builder<T, V> {
        private FieldModelBuilder(Class<T> targetType, StandardBeanProperties.Bean<T, V> bean, Rule<V> rule) {
            super(targetType, bean.properties());
            this.with(bean.type().attributeType() == null ? rule.getAttributeType() : bean.type().attributeType());
            this.with(rule.newConverter(bean.type()));
            this.with(bean.reflect());
        }
    }

    private static final class TableModelBuilder<T>
    extends DynamoDBMapperTableModel.Builder<T> {
        private TableModelBuilder(Class<T> targetType, StandardBeanProperties.Beans<T> beans, RuleFactory<Object> rules) {
            super(targetType, beans.properties());
            for (StandardBeanProperties.Bean<T, Object> bean : beans.map().values()) {
                try {
                    this.with(new FieldModelBuilder(targetType, bean, rules.getRule(bean.type())).build());
                }
                catch (RuntimeException e) {
                    throw new DynamoDBMappingException(String.format("%s[%s] could not be mapped for type %s", targetType.getSimpleName(), bean.properties().attributeName(), bean.type()), e);
                }
            }
        }
    }

    private static final class StandardModelFactory
    implements DynamoDBMapperModelFactory {
        private final ConcurrentMap<Class<?>, DynamoDBMapperTableModel<?>> cache = new ConcurrentHashMap();
        private final RuleFactory<Object> rules;

        private StandardModelFactory(RuleFactory<Object> rules) {
            this.rules = rules;
        }

        @Override
        public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> targetType) {
            if (!this.cache.containsKey(targetType)) {
                StandardBeanProperties.Beans<T> beans = StandardBeanProperties.of(targetType);
                this.cache.putIfAbsent(targetType, new TableModelBuilder(targetType, beans, this.rules).build());
            }
            return (DynamoDBMapperTableModel)this.cache.get(targetType);
        }
    }

    private static final class ConversionSchemaFactory
    implements DynamoDBMapperModelFactory.Factory {
        private final ConcurrentMap<ConversionSchema, DynamoDBMapperModelFactory> cache = new ConcurrentHashMap<ConversionSchema, DynamoDBMapperModelFactory>();
        private final S3Link.Factory s3Links;

        private ConversionSchemaFactory(S3Link.Factory s3Links) {
            this.s3Links = s3Links;
        }

        @Override
        public DynamoDBMapperModelFactory getModelFactory(DynamoDBMapperConfig config) {
            ConversionSchema schema = config.getConversionSchema();
            if (!this.cache.containsKey(schema)) {
                ConversionSchemas.ItemConverterRuleFactory rules = StandardModelFactories.rulesOf(config, this.s3Links, this);
                rules = new ConversionSchemas.ItemConverterRuleFactory(config, this.s3Links, rules);
                this.cache.putIfAbsent(schema, new StandardModelFactory(rules));
            }
            return (DynamoDBMapperModelFactory)this.cache.get(schema);
        }
    }
}

