/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBFlattened;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBKeyed;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBNamed;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScalarAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTyped;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersioned;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SdkInternalApi
final class StandardAnnotationMaps {
    StandardAnnotationMaps() {
    }

    static final <T> TableTypedMap<T> of(Class<T> clazz) {
        TableTypedMap map = new TableTypedMap(clazz);
        map.putAll(clazz);
        return map;
    }

    static final <T> FieldTypedMap<T> of(Method getter, String defaultName) {
        Class<?> targetType = getter.getReturnType();
        String fieldName = StandardBeanProperties.fieldNameOf(getter);
        Field declaredField = null;
        try {
            declaredField = getter.getDeclaringClass().getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            throw new DynamoDBMappingException("no access to field for " + getter, e);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        if (defaultName == null) {
            defaultName = fieldName;
        }
        FieldTypedMap map = new FieldTypedMap(targetType, defaultName);
        map.putAll(targetType);
        map.putAll(declaredField);
        map.putAll(getter);
        return map;
    }

    static final <A extends Annotation> A actualOf(Class<A> annotationType, Annotation annotation) {
        if (annotation == null || annotation.annotationType() == annotationType) {
            return (A)annotation;
        }
        if (annotation.annotationType().isAnnotationPresent(annotationType)) {
            return annotation.annotationType().getAnnotation(annotationType);
        }
        throw new DynamoDBMappingException("could not resolve annotation by type; @" + annotationType.getSimpleName() + " not present on " + annotation);
    }

    private static final class Annotations
    extends LinkedHashMap<Class<? extends Annotation>, Annotation> {
        private static final long serialVersionUID = -1L;

        private Annotations() {
        }

        public boolean putIfAnnotated(Class<? extends Annotation> annotationType, Annotation annotation) {
            if (!annotationType.isAnnotationPresent(DynamoDB.class)) {
                return false;
            }
            if ((annotation = this.put(annotationType, annotation)) == null) {
                return true;
            }
            throw new DynamoDBMappingException("conflicting annotations " + annotation + " and " + this.get(annotationType) + "; allowed only one of @" + annotationType.getSimpleName());
        }

        public Annotations putAll(Annotation ... annotations) {
            for (Annotation a1 : annotations) {
                this.putIfAnnotated(a1.annotationType(), a1);
                for (Annotation a2 : a1.annotationType().getAnnotations()) {
                    if (!this.putIfAnnotated(a2.annotationType(), a1)) continue;
                    for (Annotation a3 : a2.annotationType().getAnnotations()) {
                        this.putIfAnnotated(a3.annotationType(), a2);
                    }
                }
            }
            return this;
        }
    }

    static final class FieldTypedMap<T>
    extends TypedMap<T>
    implements DynamoDBMapperFieldModel.Properties<T> {
        private final String defaultName;

        private FieldTypedMap(Class<T> targetType, String defaultName) {
            super(targetType);
            this.defaultName = defaultName;
        }

        public boolean ignored() {
            return this.actualOf(DynamoDBIgnore.class) != null;
        }

        public boolean flattened() {
            return this.actualOf(DynamoDBFlattened.class) != null;
        }

        public Map<String, String> attributes() {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            for (DynamoDBAttribute a : this.actualOf(DynamoDBFlattened.class).attributes()) {
                if (a.mappedBy().isEmpty() || a.attributeName().isEmpty()) {
                    throw new DynamoDBMappingException("@DynamoDBFlattened must specify mappedBy and attributeName");
                }
                if (attributes.put(a.mappedBy(), a.attributeName()) == null) continue;
                throw new DynamoDBMappingException("@DynamoDBFlattened must not duplicate mappedBy=" + a.mappedBy());
            }
            if (attributes.isEmpty()) {
                throw new DynamoDBMappingException("@DynamoDBFlattened must specify one or more attributes");
            }
            return attributes;
        }

        @Override
        public DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
            DynamoDBScalarAttribute annotation = this.actualOf(DynamoDBScalarAttribute.class);
            if (annotation != null) {
                if (Set.class.isAssignableFrom(this.targetType())) {
                    return DynamoDBMapperFieldModel.DynamoDBAttributeType.valueOf(annotation.type().name() + "S");
                }
                return DynamoDBMapperFieldModel.DynamoDBAttributeType.valueOf(annotation.type().name());
            }
            return super.attributeType();
        }

        @Override
        public String attributeName() {
            DynamoDBHashKey hashKey = this.actualOf(DynamoDBHashKey.class);
            if (hashKey != null && !hashKey.attributeName().isEmpty()) {
                return hashKey.attributeName();
            }
            DynamoDBIndexHashKey indexHashKey = this.actualOf(DynamoDBIndexHashKey.class);
            if (indexHashKey != null && !indexHashKey.attributeName().isEmpty()) {
                return indexHashKey.attributeName();
            }
            DynamoDBRangeKey rangeKey = this.actualOf(DynamoDBRangeKey.class);
            if (rangeKey != null && !rangeKey.attributeName().isEmpty()) {
                return rangeKey.attributeName();
            }
            DynamoDBIndexRangeKey indexRangeKey = this.actualOf(DynamoDBIndexRangeKey.class);
            if (indexRangeKey != null && !indexRangeKey.attributeName().isEmpty()) {
                return indexRangeKey.attributeName();
            }
            DynamoDBAttribute attribute = this.actualOf(DynamoDBAttribute.class);
            if (attribute != null && !attribute.attributeName().isEmpty()) {
                return attribute.attributeName();
            }
            DynamoDBVersionAttribute versionAttribute = this.actualOf(DynamoDBVersionAttribute.class);
            if (versionAttribute != null && !versionAttribute.attributeName().isEmpty()) {
                return versionAttribute.attributeName();
            }
            DynamoDBScalarAttribute scalarAttribute = this.actualOf(DynamoDBScalarAttribute.class);
            if (scalarAttribute != null && !scalarAttribute.attributeName().isEmpty()) {
                return scalarAttribute.attributeName();
            }
            DynamoDBNamed annotation = this.actualOf(DynamoDBNamed.class);
            if (annotation != null && !annotation.value().isEmpty()) {
                return annotation.value();
            }
            return this.defaultName;
        }

        @Override
        public KeyType keyType() {
            DynamoDBKeyed annotation = this.actualOf(DynamoDBKeyed.class);
            if (annotation != null) {
                return annotation.value();
            }
            return null;
        }

        @Override
        public boolean versioned() {
            return this.actualOf(DynamoDBVersioned.class) != null;
        }

        @Override
        public Map<KeyType, List<String>> globalSecondaryIndexNames() {
            DynamoDBIndexRangeKey indexRangeKey;
            EnumMap<KeyType, List<String>> gsis = new EnumMap<KeyType, List<String>>(KeyType.class);
            DynamoDBIndexHashKey indexHashKey = this.actualOf(DynamoDBIndexHashKey.class);
            if (indexHashKey != null) {
                if (!indexHashKey.globalSecondaryIndexName().isEmpty()) {
                    if (indexHashKey.globalSecondaryIndexNames().length > 0) {
                        throw new DynamoDBMappingException("@DynamoDBIndexHashKey must not specify both HASH GSI name/names");
                    }
                    gsis.put(KeyType.HASH, Collections.singletonList(indexHashKey.globalSecondaryIndexName()));
                } else if (indexHashKey.globalSecondaryIndexNames().length > 0) {
                    gsis.put(KeyType.HASH, Collections.unmodifiableList(Arrays.asList(indexHashKey.globalSecondaryIndexNames())));
                } else {
                    throw new DynamoDBMappingException("@DynamoDBIndexHashKey must specify one of HASH GSI name/names");
                }
            }
            if ((indexRangeKey = this.actualOf(DynamoDBIndexRangeKey.class)) != null) {
                if (!indexRangeKey.globalSecondaryIndexName().isEmpty()) {
                    if (indexRangeKey.globalSecondaryIndexNames().length > 0) {
                        throw new DynamoDBMappingException("@DynamoDBIndexRangeKey must not specify both RANGE GSI name/names");
                    }
                    gsis.put(KeyType.RANGE, Collections.singletonList(indexRangeKey.globalSecondaryIndexName()));
                } else if (indexRangeKey.globalSecondaryIndexNames().length > 0) {
                    gsis.put(KeyType.RANGE, Collections.unmodifiableList(Arrays.asList(indexRangeKey.globalSecondaryIndexNames())));
                } else if (this.localSecondaryIndexNames().isEmpty()) {
                    throw new DynamoDBMappingException("@DynamoDBIndexRangeKey must specify RANGE GSI and/or LSI name/names");
                }
            }
            if (!gsis.isEmpty()) {
                return Collections.unmodifiableMap(gsis);
            }
            return Collections.emptyMap();
        }

        @Override
        public List<String> localSecondaryIndexNames() {
            DynamoDBIndexRangeKey annotation = this.actualOf(DynamoDBIndexRangeKey.class);
            if (annotation != null) {
                if (!annotation.localSecondaryIndexName().isEmpty()) {
                    if (annotation.localSecondaryIndexNames().length > 0) {
                        throw new DynamoDBMappingException("@DynamoDBIndexRangeKey must not specify both LSI name/names");
                    }
                    return Collections.singletonList(annotation.localSecondaryIndexName());
                }
                if (annotation.localSecondaryIndexNames().length > 0) {
                    return Collections.unmodifiableList(Arrays.asList(annotation.localSecondaryIndexNames()));
                }
            }
            return Collections.emptyList();
        }

        @Override
        public DynamoDBAutoGenerator<T> autoGenerator() {
            Annotation annotation = this.customOf(DynamoDBAutoGenerated.class);
            if (annotation != null) {
                return DynamoDBAutoGenerated.Generators.of(this.targetType(), annotation);
            }
            return null;
        }
    }

    static final class TableTypedMap<T>
    extends TypedMap<T>
    implements DynamoDBMapperTableModel.Properties<T> {
        private TableTypedMap(Class<T> targetType) {
            super(targetType);
        }

        @Override
        public DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
            DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType = super.attributeType();
            if (attributeType == null && this.actualOf(DynamoDBTable.class) != null) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.M;
            }
            return attributeType;
        }

        @Override
        public String tableName() {
            DynamoDBTable annotation = this.actualOf(DynamoDBTable.class);
            if (annotation != null && !annotation.tableName().isEmpty()) {
                return annotation.tableName();
            }
            return null;
        }
    }

    static abstract class TypedMap<T>
    extends AbstractAnnotationMap {
        private final Class<T> targetType;

        private TypedMap(Class<T> targetType) {
            this.targetType = targetType;
        }

        public <S> DynamoDBTypeConverter<S, T> typeConverter() {
            Annotation annotation = this.customOf(DynamoDBTypeConverted.class);
            if (annotation != null) {
                return DynamoDBTypeConverted.Converters.of(this.targetType, annotation);
            }
            return null;
        }

        public DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
            DynamoDBTyped annotation = this.actualOf(DynamoDBTyped.class);
            if (annotation != null) {
                return annotation.value();
            }
            return null;
        }

        public Class<T> targetType() {
            return this.targetType;
        }
    }

    private static abstract class AbstractAnnotationMap {
        private final Annotations map = new Annotations();

        private AbstractAnnotationMap() {
        }

        final void putAll(AnnotatedElement annotated) {
            if (annotated != null) {
                this.map.putAll(new Annotations().putAll(annotated.getAnnotations()));
            }
        }

        final <A extends Annotation> A actualOf(Class<A> annotationType) {
            return StandardAnnotationMaps.actualOf(annotationType, (Annotation)this.map.get(annotationType));
        }

        final <A extends Annotation> Annotation customOf(Class<A> annotationType) {
            return (Annotation)this.map.get(annotationType);
        }
    }
}

