/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

@SdkInternalApi
final class ConversionType<T> {
    private final DynamoDBTypeConverter<?, T> typeConverter;
    private final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType;
    private final ConversionType<T>[] params;
    private final Class<T> targetType;
    @Deprecated
    private final Method getter;
    @Deprecated
    private final Method setter;

    private ConversionType(Type genericType, StandardAnnotationMaps.TypedMap<T> annotations, Method getter) {
        this.typeConverter = annotations.typeConverter();
        this.attributeType = annotations.attributeType();
        if (this.typeConverter != null) {
            ConversionType<T> target = ConversionType.of(this.typeConverter);
            this.targetType = target.targetType;
            this.params = target.params;
        } else if (genericType instanceof ParameterizedType) {
            Type[] paramTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            this.targetType = annotations.targetType();
            this.params = new ConversionType[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                this.params[i] = ConversionType.of(paramTypes[i]);
            }
        } else {
            this.targetType = annotations.targetType();
            this.params = new ConversionType[0];
        }
        this.setter = getter == null ? null : StandardBeanProperties.MethodReflect.setterOf(getter);
        this.getter = getter;
    }

    final <S> DynamoDBTypeConverter<S, T> typeConverter() {
        return this.typeConverter;
    }

    final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
        return this.attributeType;
    }

    @Deprecated
    final Method getter() {
        return this.getter;
    }

    @Deprecated
    final Method setter() {
        return this.setter;
    }

    final <t> ConversionType<t> param(int index) {
        return this.params.length > index ? this.params[index] : null;
    }

    final <S> DynamoDBTypeConverter<S, T> join(DynamoDBTypeConverter<S, T> target) {
        if (this.typeConverter != null) {
            target = DynamoDBTypeConverter.AbstractConverter.join(target, this.typeConverter());
        }
        return target;
    }

    final Class<T> targetType() {
        return this.targetType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.targetType().getSimpleName()).append("<");
        for (int i = 0; i < this.params.length; ++i) {
            builder.append(i == 0 ? "" : ",").append(this.params[i]);
        }
        return builder.append(">").toString();
    }

    static <T> ConversionType<T> of(Method getter, StandardAnnotationMaps.TypedMap<T> annotations) {
        return new ConversionType<T>(getter.getGenericReturnType(), annotations, getter);
    }

    private static <T> ConversionType<T> of(DynamoDBTypeConverter<?, T> converter) {
        Class<?> clazz = converter.getClass();
        if (!clazz.isInterface()) {
            for (Class<?> c = clazz; Object.class != c; c = c.getSuperclass()) {
                for (Type genericType : c.getGenericInterfaces()) {
                    ConversionType<T> type = ConversionType.of(genericType);
                    if (!DynamoDBTypeConverter.class.isAssignableFrom(type.targetType()) || type.params.length != 2 || type.param(0).targetType() == Object.class) continue;
                    return type.param(0);
                }
            }
            ConversionType<T> type = ConversionType.of(clazz.getGenericSuperclass());
            if (DynamoDBTypeConverter.class.isAssignableFrom(type.targetType()) && type.params.length > 0 && type.param(0).targetType() != Object.class) {
                return type.param(0);
            }
        }
        throw new DynamoDBMappingException("could not resolve type of " + clazz);
    }

    private static <T> ConversionType<T> of(Type genericType) {
        Class targetType = genericType instanceof Class ? (Class<byte[]>)((Object)genericType) : (genericType instanceof ParameterizedType ? (Class)((ParameterizedType)genericType).getRawType() : (genericType.toString().equals("byte[]") ? byte[].class : Object.class));
        StandardAnnotationMaps.TableTypedMap annotations = StandardAnnotationMaps.of(targetType);
        return new ConversionType(genericType, annotations, null);
    }
}

