/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionType;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBNativeBoolean;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.ItemConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardModelFactories;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.BooleanSetToNumberSetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.BooleanToBooleanMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.BooleanToNumberMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.ByteArraySetToBinarySetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.ByteArrayToBinaryMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.ByteBufferSetToBinarySetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.ByteBufferToBinaryMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CalendarSetToStringSetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CalendarToStringMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CollectionToListMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CustomMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.DateSetToStringSetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.DateToStringMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.MapToMapMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.NumberSetToNumberSetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.NumberToNumberMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.ObjectSetToStringSetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.ObjectToMapMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.ObjectToStringMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.S3LinkToStringMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.StringSetToStringSetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.StringToStringMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.UUIDSetToStringSetMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BigDecimalSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BigDecimalUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BigIntegerSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BigIntegerUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BooleanSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BooleanUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ByteArraySetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ByteArrayUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ByteBufferSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ByteBufferUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ByteSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ByteUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.CalendarSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.CalendarUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.CustomUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.DateSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.DateUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.DoubleSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.DoubleUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.FloatSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.FloatUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.IntegerSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.IntegerUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ListUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.LongSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.LongUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.MapUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.NullableUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ObjectSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ObjectUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.S3LinkUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ShortSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.ShortUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.StringSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.StringUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.UUIDSetUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.UUIDUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConversionSchemas {
    private static final Log LOGGER = LogFactory.getLog(ConversionSchemas.class);
    public static final ConversionSchema V1 = ConversionSchemas.v1Builder("V1ConversionSchema").build();
    public static final ConversionSchema V2_COMPATIBLE = ConversionSchemas.v2CompatibleBuilder("V2CompatibleConversionSchema").build();
    public static final ConversionSchema V2 = ConversionSchemas.v2Builder("V2ConversionSchema").build();
    static final ConversionSchema DEFAULT = V2_COMPATIBLE;

    public static Builder v1Builder(String name) {
        return new Builder(name, V1MarshallerSet.marshallers(), V1MarshallerSet.setMarshallers(), StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
    }

    public static Builder v2CompatibleBuilder(String name) {
        return new Builder(name, V2CompatibleMarshallerSet.marshallers(), V2CompatibleMarshallerSet.setMarshallers(), StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
    }

    public static Builder v2Builder(String name) {
        return new Builder(name, V2MarshallerSet.marshallers(), V2MarshallerSet.setMarshallers(), StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
    }

    private static void addStandardDateMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Date.class, DateToStringMarshaller.instance()));
        list.add(Pair.of(Calendar.class, CalendarToStringMarshaller.instance()));
    }

    private static void addV1BooleanMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanToNumberMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanToNumberMarshaller.instance()));
    }

    private static void addV2BooleanMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanToBooleanMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanToBooleanMarshaller.instance()));
    }

    private static void addStandardNumberMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Number.class, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Byte.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Short.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Integer.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Long.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Float.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Double.TYPE, NumberToNumberMarshaller.instance()));
    }

    private static void addStandardStringMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(String.class, StringToStringMarshaller.instance()));
        list.add(Pair.of(UUID.class, ObjectToStringMarshaller.instance()));
    }

    private static void addStandardBinaryMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(ByteBuffer.class, ByteBufferToBinaryMarshaller.instance()));
        list.add(Pair.of(byte[].class, ByteArrayToBinaryMarshaller.instance()));
    }

    private static void addStandardS3LinkMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(S3Link.class, S3LinkToStringMarshaller.instance()));
    }

    private static void addStandardDateSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Date.class, DateSetToStringSetMarshaller.instance()));
        list.add(Pair.of(Calendar.class, CalendarSetToStringSetMarshaller.instance()));
    }

    private static void addStandardNumberSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Number.class, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Byte.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Short.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Integer.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Long.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Float.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Double.TYPE, NumberSetToNumberSetMarshaller.instance()));
    }

    private static void addStandardStringSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(String.class, StringSetToStringSetMarshaller.instance()));
        list.add(Pair.of(UUID.class, UUIDSetToStringSetMarshaller.instance()));
    }

    private static void addStandardBinarySetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(ByteBuffer.class, ByteBufferSetToBinarySetMarshaller.instance()));
        list.add(Pair.of(byte[].class, ByteArraySetToBinarySetMarshaller.instance()));
    }

    private static void addV1BooleanSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanSetToNumberSetMarshaller.instance()));
    }

    private static Class<?> unwrapGenericSetParam(Type setType) {
        if (!(setType instanceof ParameterizedType)) {
            LOGGER.warn((Object)("Set type " + setType + " is not a ParameterizedType, using default marshaler and unmarshaler!"));
            return Object.class;
        }
        ParameterizedType ptype = (ParameterizedType)setType;
        Type[] arguments = ptype.getActualTypeArguments();
        if (arguments.length != 1) {
            LOGGER.warn((Object)("Set type " + setType + " does not have exactly one type argument, using default marshaler and unmarshaler!"));
            return Object.class;
        }
        if (arguments[0].toString().equals("byte[]")) {
            return byte[].class;
        }
        return (Class)arguments[0];
    }

    private static Class<?> resolveClass(Type type) {
        Type localType = type;
        if (localType instanceof ParameterizedType) {
            localType = ((ParameterizedType)type).getRawType();
        }
        if (!(localType instanceof Class)) {
            throw new DynamoDBMappingException("Cannot resolve class for type " + type);
        }
        return (Class)localType;
    }

    private static <T> T find(Class<?> needle, List<Pair<T>> haystack) {
        for (Pair<T> pair : haystack) {
            if (!pair.key.isAssignableFrom(needle)) continue;
            return pair.value;
        }
        return null;
    }

    ConversionSchemas() {
        throw new UnsupportedOperationException();
    }

    static class ItemConverterRuleFactory<V>
    implements StandardModelFactories.RuleFactory<V> {
        private final StandardModelFactories.RuleFactory<V> typeConverters;
        private final ItemConverter converter;
        private final boolean customSchema;

        ItemConverterRuleFactory(DynamoDBMapperConfig config, S3Link.Factory s3Links, StandardModelFactories.RuleFactory<V> typeConverters) {
            ConversionSchema.Dependencies depends = new ConversionSchema.Dependencies().with(S3ClientCache.class, s3Links.getS3ClientCache());
            ConversionSchema schema = config.getConversionSchema();
            this.customSchema = schema != V1 && schema != V2_COMPATIBLE && schema != V2;
            this.converter = schema.getConverter(depends);
            this.typeConverters = typeConverters;
        }

        @Override
        public StandardModelFactories.Rule<V> getRule(ConversionType<V> type) {
            if (this.customSchema && type.typeConverter() == null) {
                return new ItemConverterRule(type);
            }
            return this.typeConverters.getRule(type);
        }

        private final class ItemConverterRule<V>
        implements StandardModelFactories.Rule<V>,
        DynamoDBTypeConverter<AttributeValue, V> {
            private final ConversionType<V> type;

            private ItemConverterRule(ConversionType<V> type) {
                this.type = type;
            }

            @Override
            public boolean isAssignableFrom(ConversionType<?> type) {
                return true;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(ConversionType<V> type) {
                return this;
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                try {
                    return ItemConverterRuleFactory.this.converter.getFieldModel(this.type.getter()).attributeType();
                }
                catch (DynamoDBMappingException dynamoDBMappingException) {
                    return DynamoDBMapperFieldModel.DynamoDBAttributeType.NULL;
                }
            }

            @Override
            public AttributeValue convert(V object) {
                return ItemConverterRuleFactory.this.converter.convert(this.type.getter(), object);
            }

            @Override
            public V unconvert(AttributeValue object) {
                return (V)ItemConverterRuleFactory.this.converter.unconvert(this.type.getter(), this.type.setter(), object);
            }
        }
    }

    static class CachingUnmarshallerSet
    implements UnmarshallerSet {
        private final Map<Method, ArgumentUnmarshaller> cache = new HashMap<Method, ArgumentUnmarshaller>();
        private final Map<Type, ArgumentUnmarshaller> memberCache = new HashMap<Type, ArgumentUnmarshaller>();
        private final UnmarshallerSet wrapped;

        public CachingUnmarshallerSet(UnmarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            Map<Method, ArgumentUnmarshaller> map = this.cache;
            synchronized (map) {
                ArgumentUnmarshaller unmarshaler = this.cache.get(getter);
                if (unmarshaler != null) {
                    return unmarshaler;
                }
                unmarshaler = this.wrapped.getUnmarshaller(getter, setter);
                this.cache.put(getter, unmarshaler);
                return unmarshaler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentUnmarshaller getMemberUnmarshaller(Type memberType) {
            Map<Type, ArgumentUnmarshaller> map = this.memberCache;
            synchronized (map) {
                ArgumentUnmarshaller unmarshaller = this.memberCache.get(memberType);
                if (unmarshaller != null) {
                    return unmarshaller;
                }
                unmarshaller = this.wrapped.getMemberUnmarshaller(memberType);
                this.memberCache.put(memberType, unmarshaller);
                return unmarshaller;
            }
        }
    }

    static class CachingMarshallerSet
    implements MarshallerSet {
        private final Map<Method, ArgumentMarshaller> cache = new HashMap<Method, ArgumentMarshaller>();
        private final Map<Type, ArgumentMarshaller> memberCache = new HashMap<Type, ArgumentMarshaller>();
        private final MarshallerSet wrapped;

        public CachingMarshallerSet(MarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentMarshaller getMarshaller(Method getter) {
            Map<Method, ArgumentMarshaller> map = this.cache;
            synchronized (map) {
                ArgumentMarshaller marshaler = this.cache.get(getter);
                if (marshaler != null) {
                    return marshaler;
                }
                marshaler = this.wrapped.getMarshaller(getter);
                this.cache.put(getter, marshaler);
                return marshaler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArgumentMarshaller getMemberMarshaller(Type memberType) {
            Map<Type, ArgumentMarshaller> map = this.memberCache;
            synchronized (map) {
                ArgumentMarshaller marshaller = this.memberCache.get(memberType);
                if (marshaller != null) {
                    return marshaller;
                }
                marshaller = this.wrapped.getMemberMarshaller(memberType);
                this.memberCache.put(memberType, marshaller);
                return marshaller;
            }
        }
    }

    static class AnnotationAwareUnmarshallerSet
    implements UnmarshallerSet {
        private final UnmarshallerSet wrapped;

        public AnnotationAwareUnmarshallerSet(UnmarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            StandardAnnotationMaps.FieldTypedMap annotations = StandardAnnotationMaps.of(getter, null);
            DynamoDBMarshalling marshalling = annotations.actualOf(DynamoDBMarshalling.class);
            if (marshalling != null) {
                return new CustomUnmarshaller(getter.getReturnType(), marshalling.marshallerClass());
            }
            return this.wrapped.getUnmarshaller(getter, setter);
        }

        @Override
        public ArgumentUnmarshaller getMemberUnmarshaller(Type c) {
            return this.wrapped.getMemberUnmarshaller(c);
        }
    }

    static class AnnotationAwareMarshallerSet
    implements MarshallerSet {
        private final MarshallerSet wrapped;

        public AnnotationAwareMarshallerSet(MarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ArgumentMarshaller getMarshaller(Method getter) {
            StandardAnnotationMaps.FieldTypedMap annotations = StandardAnnotationMaps.of(getter, null);
            DynamoDBMarshalling marshalling = annotations.actualOf(DynamoDBMarshalling.class);
            if (marshalling != null) {
                return new CustomMarshaller(marshalling.marshallerClass());
            }
            if (annotations.actualOf(DynamoDBNativeBoolean.class) != null) {
                return BooleanToBooleanMarshaller.instance();
            }
            return this.wrapped.getMarshaller(getter);
        }

        @Override
        public ArgumentMarshaller getMemberMarshaller(Type memberType) {
            return this.wrapped.getMemberMarshaller(memberType);
        }
    }

    private static class Pair<T> {
        public final Class<?> key;
        public final T value;

        public static Pair<ArgumentMarshaller> of(Class<?> key, ArgumentMarshaller value) {
            return new Pair<ArgumentMarshaller>(key, value);
        }

        public static Pair<ArgumentUnmarshaller> of(Class<?> key, ArgumentUnmarshaller value) {
            return new Pair<ArgumentUnmarshaller>(key, value);
        }

        private Pair(Class<?> key, T value) {
            this.key = key;
            this.value = value;
        }
    }

    static class StandardUnmarshallerSet
    implements UnmarshallerSet {
        private final List<Pair<ArgumentUnmarshaller>> unmarshallers;
        private final List<Pair<ArgumentUnmarshaller>> setUnmarshallers;

        public StandardUnmarshallerSet() {
            this(StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
        }

        public StandardUnmarshallerSet(List<Pair<ArgumentUnmarshaller>> unmarshallers, List<Pair<ArgumentUnmarshaller>> setUnmarshallers) {
            this.unmarshallers = unmarshallers;
            this.setUnmarshallers = setUnmarshallers;
        }

        private static List<Pair<ArgumentUnmarshaller>> unmarshallers() {
            ArrayList<Pair<ArgumentUnmarshaller>> list = new ArrayList<Pair<ArgumentUnmarshaller>>();
            list.add(Pair.of(Double.TYPE, DoubleUnmarshaller.instance()));
            list.add(Pair.of(Double.class, DoubleUnmarshaller.instance()));
            list.add(Pair.of(BigDecimal.class, BigDecimalUnmarshaller.instance()));
            list.add(Pair.of(BigInteger.class, BigIntegerUnmarshaller.instance()));
            list.add(Pair.of(Integer.TYPE, IntegerUnmarshaller.instance()));
            list.add(Pair.of(Integer.class, IntegerUnmarshaller.instance()));
            list.add(Pair.of(Float.TYPE, FloatUnmarshaller.instance()));
            list.add(Pair.of(Float.class, FloatUnmarshaller.instance()));
            list.add(Pair.of(Byte.TYPE, ByteUnmarshaller.instance()));
            list.add(Pair.of(Byte.class, ByteUnmarshaller.instance()));
            list.add(Pair.of(Long.TYPE, LongUnmarshaller.instance()));
            list.add(Pair.of(Long.class, LongUnmarshaller.instance()));
            list.add(Pair.of(Short.TYPE, ShortUnmarshaller.instance()));
            list.add(Pair.of(Short.class, ShortUnmarshaller.instance()));
            list.add(Pair.of(Boolean.TYPE, BooleanUnmarshaller.instance()));
            list.add(Pair.of(Boolean.class, BooleanUnmarshaller.instance()));
            list.add(Pair.of(Date.class, DateUnmarshaller.instance()));
            list.add(Pair.of(Calendar.class, CalendarUnmarshaller.instance()));
            list.add(Pair.of(ByteBuffer.class, ByteBufferUnmarshaller.instance()));
            list.add(Pair.of(byte[].class, ByteArrayUnmarshaller.instance()));
            list.add(Pair.of(S3Link.class, S3LinkUnmarshaller.instance()));
            list.add(Pair.of(UUID.class, UUIDUnmarshaller.instance()));
            list.add(Pair.of(String.class, StringUnmarshaller.instance()));
            list.add(Pair.of(List.class, ListUnmarshaller.instance()));
            list.add(Pair.of(Map.class, MapUnmarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectUnmarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentUnmarshaller>> setUnmarshallers() {
            ArrayList<Pair<ArgumentUnmarshaller>> list = new ArrayList<Pair<ArgumentUnmarshaller>>();
            list.add(Pair.of(Double.TYPE, DoubleSetUnmarshaller.instance()));
            list.add(Pair.of(Double.class, DoubleSetUnmarshaller.instance()));
            list.add(Pair.of(BigDecimal.class, BigDecimalSetUnmarshaller.instance()));
            list.add(Pair.of(BigInteger.class, BigIntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Integer.TYPE, IntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Integer.class, IntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Float.TYPE, FloatSetUnmarshaller.instance()));
            list.add(Pair.of(Float.class, FloatSetUnmarshaller.instance()));
            list.add(Pair.of(Byte.TYPE, ByteSetUnmarshaller.instance()));
            list.add(Pair.of(Byte.class, ByteSetUnmarshaller.instance()));
            list.add(Pair.of(Long.TYPE, LongSetUnmarshaller.instance()));
            list.add(Pair.of(Long.class, LongSetUnmarshaller.instance()));
            list.add(Pair.of(Short.TYPE, ShortSetUnmarshaller.instance()));
            list.add(Pair.of(Short.class, ShortSetUnmarshaller.instance()));
            list.add(Pair.of(Boolean.TYPE, BooleanSetUnmarshaller.instance()));
            list.add(Pair.of(Boolean.class, BooleanSetUnmarshaller.instance()));
            list.add(Pair.of(Date.class, DateSetUnmarshaller.instance()));
            list.add(Pair.of(Calendar.class, CalendarSetUnmarshaller.instance()));
            list.add(Pair.of(ByteBuffer.class, ByteBufferSetUnmarshaller.instance()));
            list.add(Pair.of(byte[].class, ByteArraySetUnmarshaller.instance()));
            list.add(Pair.of(UUID.class, UUIDSetUnmarshaller.instance()));
            list.add(Pair.of(String.class, StringSetUnmarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectSetUnmarshaller.instance()));
            return list;
        }

        @Override
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            if (setter.getParameterTypes().length != 1) {
                throw new DynamoDBMappingException("Expected exactly one agument to " + setter);
            }
            Class paramType = setter.getParameterTypes()[0];
            if (Set.class.isAssignableFrom(paramType)) {
                paramType = ConversionSchemas.unwrapGenericSetParam(setter.getGenericParameterTypes()[0]);
                return this.getSet(setter, paramType);
            }
            return this.getScalar(setter, paramType);
        }

        @Override
        public ArgumentUnmarshaller getMemberUnmarshaller(Type memberType) {
            Class clazz = ConversionSchemas.resolveClass(memberType);
            if (Set.class.isAssignableFrom(clazz)) {
                Class setMemberType = ConversionSchemas.unwrapGenericSetParam(memberType);
                return this.getSet(null, setMemberType);
            }
            return this.getScalar(null, clazz);
        }

        private ArgumentUnmarshaller getSet(Method setter, Class<?> paramType) {
            ArgumentUnmarshaller unmarshaller = (ArgumentUnmarshaller)ConversionSchemas.find(paramType, this.setUnmarshallers);
            String className = "?";
            String methodName = "?";
            if (setter != null) {
                className = setter.getDeclaringClass().toString();
                methodName = setter.getName();
            }
            if (unmarshaller == null) {
                throw new DynamoDBMappingException("Cannot unmarshall to parameter type Set<" + paramType + "> of method " + className + "." + methodName + " without a custom unmarshaler.");
            }
            return unmarshaller;
        }

        private ArgumentUnmarshaller getScalar(Method setter, Class<?> type) {
            ArgumentUnmarshaller unmarshaller = (ArgumentUnmarshaller)ConversionSchemas.find(type, this.unmarshallers);
            String className = "?";
            String methodName = "?";
            if (setter != null) {
                className = setter.getDeclaringClass().toString();
                methodName = setter.getName();
            }
            if (unmarshaller == null) {
                throw new DynamoDBMappingException("Cannot unmarshall to parameter type " + type + "of method " + className + "." + methodName + " without a custom unmarshaler.");
            }
            return unmarshaller;
        }
    }

    private static class AbstractMarshallerSet
    implements MarshallerSet {
        private final List<Pair<ArgumentMarshaller>> marshallers;
        private final List<Pair<ArgumentMarshaller>> setMarshallers;

        public AbstractMarshallerSet(List<Pair<ArgumentMarshaller>> marshallers, List<Pair<ArgumentMarshaller>> setMarshallers) {
            this.marshallers = marshallers;
            this.setMarshallers = setMarshallers;
        }

        @Override
        public ArgumentMarshaller getMarshaller(Method getter) {
            Class<?> returnType = getter.getReturnType();
            if (Set.class.isAssignableFrom(returnType)) {
                Class memberType = ConversionSchemas.unwrapGenericSetParam(getter.getGenericReturnType());
                return this.getSet(getter, memberType);
            }
            return this.getScalar(getter, returnType);
        }

        @Override
        public ArgumentMarshaller getMemberMarshaller(Type memberType) {
            Class clazz = ConversionSchemas.resolveClass(memberType);
            if (Set.class.isAssignableFrom(clazz)) {
                Class setMemberType = ConversionSchemas.unwrapGenericSetParam(memberType);
                return this.getSet(null, setMemberType);
            }
            return this.getScalar(null, clazz);
        }

        private ArgumentMarshaller getScalar(Method getter, Class<?> type) {
            ArgumentMarshaller marshaller = (ArgumentMarshaller)ConversionSchemas.find(type, this.marshallers);
            if (marshaller == null) {
                String className = "?";
                String methodName = "?";
                if (getter != null) {
                    className = getter.getDeclaringClass().toString();
                    methodName = getter.getName();
                }
                throw new DynamoDBMappingException("Cannot marshall return type " + type + " of method " + className + "." + methodName + " without a custom marshaler.");
            }
            return marshaller;
        }

        private ArgumentMarshaller getSet(Method getter, Class<?> memberType) {
            ArgumentMarshaller marshaller = (ArgumentMarshaller)ConversionSchemas.find(memberType, this.setMarshallers);
            if (marshaller == null) {
                String className = "?";
                String methodName = "?";
                if (getter != null) {
                    className = getter.getDeclaringClass().toString();
                    methodName = getter.getName();
                }
                throw new DynamoDBMappingException("Cannot marshall return type Set<" + memberType + "> of method " + className + "." + methodName + " without a custom marshaller.");
            }
            return marshaller;
        }
    }

    static final class V1MarshallerSet {
        V1MarshallerSet() {
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV1BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addV1BooleanSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, ObjectSetToStringSetMarshaller.instance()));
            return list;
        }
    }

    static final class V2CompatibleMarshallerSet {
        V2CompatibleMarshallerSet() {
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV1BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            list.add(Pair.of(List.class, CollectionToListMarshaller.instance()));
            list.add(Pair.of(Map.class, MapToMapMarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectToMapMarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addV1BooleanSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, ObjectSetToStringSetMarshaller.instance()));
            return list;
        }
    }

    static final class V2MarshallerSet {
        V2MarshallerSet() {
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV2BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            list.add(Pair.of(List.class, CollectionToListMarshaller.instance()));
            list.add(Pair.of(Map.class, MapToMapMarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectToMapMarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, CollectionToListMarshaller.instance()));
            return list;
        }
    }

    static interface UnmarshallerSet {
        public ArgumentUnmarshaller getUnmarshaller(Method var1, Method var2);

        public ArgumentUnmarshaller getMemberUnmarshaller(Type var1);
    }

    static interface MarshallerSet {
        public ArgumentMarshaller getMarshaller(Method var1);

        public ArgumentMarshaller getMemberMarshaller(Type var1);
    }

    static class StandardItemConverter
    implements ItemConverter {
        private final MarshallerSet marshallerSet;
        private final UnmarshallerSet unmarshallerSet;
        private final S3ClientCache s3cc;

        public StandardItemConverter(MarshallerSet marshallerSet, UnmarshallerSet unmarshallerSet, S3ClientCache s3cc) {
            this.marshallerSet = marshallerSet;
            this.unmarshallerSet = unmarshallerSet;
            this.s3cc = s3cc;
        }

        @Override
        public DynamoDBMapperFieldModel getFieldModel(Method getter) {
            DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType;
            ArgumentMarshaller marshaller = this.getMarshaller(getter);
            if (marshaller instanceof ArgumentMarshaller.StringAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.S;
            } else if (marshaller instanceof ArgumentMarshaller.NumberAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.N;
            } else if (marshaller instanceof ArgumentMarshaller.BinaryAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.B;
            } else if (marshaller instanceof ArgumentMarshaller.StringSetAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.SS;
            } else if (marshaller instanceof ArgumentMarshaller.NumberSetAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.NS;
            } else if (marshaller instanceof ArgumentMarshaller.BinarySetAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.BS;
            } else if (marshaller instanceof ArgumentMarshaller.BooleanAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.BOOL;
            } else if (marshaller instanceof ArgumentMarshaller.ListAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.L;
            } else if (marshaller instanceof ArgumentMarshaller.MapAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.M;
            } else {
                throw new DynamoDBMappingException("Unrecognized marshaller type for " + getter + ": " + marshaller);
            }
            StandardAnnotationMaps.FieldTypedMap annotations = StandardAnnotationMaps.of(getter, null);
            DynamoDBMapperFieldModel.Builder builder = new DynamoDBMapperFieldModel.Builder(Void.TYPE, annotations);
            builder.with(attributeType);
            return builder.build();
        }

        @Override
        public AttributeValue convert(Method getter, Object object) {
            if (object == null) {
                return null;
            }
            ArgumentMarshaller marshaller = this.getMarshaller(getter);
            return marshaller.marshall(object);
        }

        @Override
        public Map<String, AttributeValue> convert(Object object) {
            if (object == null) {
                return null;
            }
            Class<?> clazz = object.getClass();
            HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
            for (StandardBeanProperties.Bean<?, Object> bean : StandardBeanProperties.of(clazz).map().values()) {
                AttributeValue value;
                Object getterResult = bean.reflect().get(object);
                if (getterResult == null || (value = this.convert(bean.type().getter(), getterResult)) == null) continue;
                result.put(bean.properties().attributeName(), value);
            }
            return result;
        }

        private ArgumentMarshaller getMarshaller(Method getter) {
            ArgumentMarshaller marshaller = this.marshallerSet.getMarshaller(getter);
            marshaller = this.augment(getter.getGenericReturnType(), marshaller);
            return marshaller;
        }

        private ArgumentMarshaller getMemberMarshaller(Type type) {
            ArgumentMarshaller marshaller = this.marshallerSet.getMemberMarshaller(type);
            marshaller = this.augment(type, marshaller);
            return marshaller;
        }

        private ArgumentMarshaller augment(Type type, ArgumentMarshaller marshaller) {
            if (marshaller instanceof CollectionToListMarshaller) {
                return this.getCollectionToListMarshaller(type);
            }
            if (marshaller instanceof MapToMapMarshaller) {
                return this.getMapToMapMarshaller(type);
            }
            if (marshaller instanceof ObjectToMapMarshaller) {
                return this.getObjectToMapMarshaller(type);
            }
            return marshaller;
        }

        private ArgumentMarshaller getCollectionToListMarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Collection type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Collection type " + type + "; unexpected number of type arguments.");
            }
            ArgumentMarshaller memberMarshaller = this.getMemberMarshaller(args[0]);
            return new CollectionToListMarshaller(memberMarshaller);
        }

        private ArgumentMarshaller getMapToMapMarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 2) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + "; unexpected number of type arguments.");
            }
            if (args[0] != String.class) {
                throw new DynamoDBMappingException("Only Map<String, ?> is supported.");
            }
            ArgumentMarshaller memberMarshaller = this.getMemberMarshaller(args[1]);
            return new MapToMapMarshaller(memberMarshaller);
        }

        private ArgumentMarshaller getObjectToMapMarshaller(Type type) {
            Type localType = type;
            if (localType instanceof ParameterizedType) {
                localType = ((ParameterizedType)localType).getRawType();
            }
            if (!(localType instanceof Class)) {
                throw new DynamoDBMappingException("Cannot convert " + type + " to a class");
            }
            Class clazz = (Class)localType;
            if (StandardAnnotationMaps.of(clazz).attributeType() != DynamoDBMapperFieldModel.DynamoDBAttributeType.M) {
                throw new DynamoDBMappingException("Cannot marshall type " + type + " without a custom marshaler or @DynamoDBDocument annotation.");
            }
            return new ObjectToMapMarshaller(this);
        }

        @Override
        public Object unconvert(Method getter, Method setter, AttributeValue value) {
            ArgumentUnmarshaller unmarshaller = this.getUnmarshaller(getter, setter);
            return StandardItemConverter.unmarshall(unmarshaller, setter, value);
        }

        @Override
        public <T> T unconvert(Class<T> clazz, Map<String, AttributeValue> value) {
            T result = StandardItemConverter.createObject(clazz);
            if (value == null || value.isEmpty()) {
                return result;
            }
            for (StandardBeanProperties.Bean<T, Object> bean : StandardBeanProperties.of(clazz).map().values()) {
                AttributeValue av = value.get(bean.properties().attributeName());
                if (av == null) continue;
                ArgumentUnmarshaller unmarshaller = this.getUnmarshaller(bean.type().getter(), bean.type().setter());
                Object unmarshalled = StandardItemConverter.unmarshall(unmarshaller, bean.type().setter(), av);
                bean.reflect().set(result, unmarshalled);
            }
            return result;
        }

        private ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            ArgumentUnmarshaller unmarshaller = this.unmarshallerSet.getUnmarshaller(getter, setter);
            unmarshaller = this.augment(setter.getGenericParameterTypes()[0], unmarshaller);
            return new NullableUnmarshaller(unmarshaller);
        }

        private ArgumentUnmarshaller getMemberUnmarshaller(Type type) {
            ArgumentUnmarshaller unmarshaller = this.unmarshallerSet.getMemberUnmarshaller(type);
            unmarshaller = this.augment(type, unmarshaller);
            return new NullableUnmarshaller(unmarshaller);
        }

        private ArgumentUnmarshaller augment(Type type, ArgumentUnmarshaller unmarshaller) {
            if (unmarshaller instanceof S3LinkUnmarshaller) {
                return new S3LinkUnmarshaller(this.s3cc);
            }
            if (unmarshaller instanceof ObjectSetUnmarshaller) {
                return this.getObjectSetUnmarshaller(type);
            }
            if (unmarshaller instanceof ListUnmarshaller) {
                return this.getListUnmarshaller(type);
            }
            if (unmarshaller instanceof MapUnmarshaller) {
                return this.getMapUnmarshaller(type);
            }
            if (unmarshaller instanceof ObjectUnmarshaller) {
                return this.getObjectUnmarshaller(type);
            }
            return unmarshaller;
        }

        private ArgumentUnmarshaller getObjectSetUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Set type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Set type " + type + "; unexpected number of type arguments.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.getMemberUnmarshaller(args[0]);
            return new ObjectSetUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller getListUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the List type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the List type " + type + "; unexpected number of type arguments.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.getMemberUnmarshaller(args[0]);
            return new ListUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller getMapUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 2) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + "; unexpected number of type arguments.");
            }
            if (args[0] != String.class) {
                throw new DynamoDBMappingException("Only Map<String, ?> is supported.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.getMemberUnmarshaller(args[1]);
            return new MapUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller getObjectUnmarshaller(Type type) {
            Type localType = type;
            if (localType instanceof ParameterizedType) {
                localType = ((ParameterizedType)type).getRawType();
            }
            if (!(localType instanceof Class)) {
                throw new DynamoDBMappingException("Cannot convert " + type + " to a class");
            }
            Class clazz = (Class)localType;
            if (StandardAnnotationMaps.of(clazz).attributeType() != DynamoDBMapperFieldModel.DynamoDBAttributeType.M) {
                throw new DynamoDBMappingException("Cannot unmarshall to type " + type + " without a custom marshaler or @DynamoDBDocument annotation.");
            }
            return new ObjectUnmarshaller(this, clazz);
        }

        private static Object unmarshall(ArgumentUnmarshaller unmarshaller, Method setter, AttributeValue value) {
            unmarshaller.typeCheck(value, setter);
            try {
                return unmarshaller.unmarshall(value);
            }
            catch (IllegalArgumentException e) {
                throw new DynamoDBMappingException("Couldn't unmarshall value " + value + " for " + setter, e);
            }
            catch (ParseException e) {
                throw new DynamoDBMappingException("Error attempting to parse date string " + value + " for " + setter, e);
            }
        }

        private static <T> T createObject(Class<T> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
            }
            catch (IllegalAccessException e) {
                throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
            }
        }
    }

    static class StandardConversionSchema
    implements ConversionSchema {
        private final String name;
        private final MarshallerSet marshallers;
        private final UnmarshallerSet unmarshallers;

        public StandardConversionSchema(String name, MarshallerSet marshallers, UnmarshallerSet unmarshallers) {
            this.name = name;
            this.marshallers = new CachingMarshallerSet(new AnnotationAwareMarshallerSet(marshallers));
            this.unmarshallers = new CachingUnmarshallerSet(new AnnotationAwareUnmarshallerSet(unmarshallers));
        }

        @Override
        public ItemConverter getConverter(ConversionSchema.Dependencies dependencies) {
            S3ClientCache s3cc = dependencies.get(S3ClientCache.class);
            return new StandardItemConverter(this.marshallers, this.unmarshallers, s3cc);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Builder {
        private final String name;
        private final List<Pair<ArgumentMarshaller>> marshallers;
        private final List<Pair<ArgumentMarshaller>> setMarshallers;
        private final List<Pair<ArgumentUnmarshaller>> unmarshallers;
        private final List<Pair<ArgumentUnmarshaller>> setUnmarshallers;

        Builder(String name, List<Pair<ArgumentMarshaller>> marshallers, List<Pair<ArgumentMarshaller>> setMarshallers, List<Pair<ArgumentUnmarshaller>> unmarshallers, List<Pair<ArgumentUnmarshaller>> setUnmarshallers) {
            this.name = name;
            this.marshallers = marshallers;
            this.setMarshallers = setMarshallers;
            this.unmarshallers = unmarshallers;
            this.setUnmarshallers = setUnmarshallers;
        }

        public Builder addFirstType(Class<?> clazz, ArgumentMarshaller marshaller, ArgumentUnmarshaller unmarshaller) {
            this.marshallers.add(0, Pair.of(clazz, marshaller));
            this.unmarshallers.add(0, Pair.of(clazz, unmarshaller));
            return this;
        }

        public Builder addFirstSetType(Class<?> clazz, ArgumentMarshaller marshaller, ArgumentUnmarshaller unmarshaller) {
            this.setMarshallers.add(0, Pair.of(clazz, marshaller));
            this.setUnmarshallers.add(0, Pair.of(clazz, unmarshaller));
            return this;
        }

        public ConversionSchema build() {
            return new StandardConversionSchema(this.name, new AbstractMarshallerSet(this.marshallers, this.setMarshallers), new StandardUnmarshallerSet(this.unmarshallers, this.setUnmarshallers));
        }
    }
}

