/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.CreateRemoteAccessSessionRequest;
import com.amazonaws.services.devicefarm.model.transform.CreateRemoteAccessSessionConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateRemoteAccessSessionRequestMarshaller
implements Marshaller<Request<CreateRemoteAccessSessionRequest>, CreateRemoteAccessSessionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateRemoteAccessSessionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateRemoteAccessSessionRequest> marshall(CreateRemoteAccessSessionRequest createRemoteAccessSessionRequest) {
        if (createRemoteAccessSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRemoteAccessSessionRequest> request = new DefaultRequest<CreateRemoteAccessSessionRequest>(createRemoteAccessSessionRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.CreateRemoteAccessSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createRemoteAccessSessionRequest.getProjectArn() != null) {
                jsonGenerator.writeFieldName("projectArn").writeValue(createRemoteAccessSessionRequest.getProjectArn());
            }
            if (createRemoteAccessSessionRequest.getDeviceArn() != null) {
                jsonGenerator.writeFieldName("deviceArn").writeValue(createRemoteAccessSessionRequest.getDeviceArn());
            }
            if (createRemoteAccessSessionRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createRemoteAccessSessionRequest.getName());
            }
            if (createRemoteAccessSessionRequest.getConfiguration() != null) {
                jsonGenerator.writeFieldName("configuration");
                CreateRemoteAccessSessionConfigurationJsonMarshaller.getInstance().marshall(createRemoteAccessSessionRequest.getConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

