/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.GitHubLocation;

public class GitHubLocationJsonMarshaller {
    private static GitHubLocationJsonMarshaller instance;

    public void marshall(GitHubLocation gitHubLocation, StructuredJsonGenerator jsonGenerator) {
        if (gitHubLocation == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (gitHubLocation.getRepository() != null) {
                jsonGenerator.writeFieldName("repository").writeValue(gitHubLocation.getRepository());
            }
            if (gitHubLocation.getCommitId() != null) {
                jsonGenerator.writeFieldName("commitId").writeValue(gitHubLocation.getCommitId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GitHubLocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GitHubLocationJsonMarshaller();
        }
        return instance;
    }
}

