/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ModifyOptionGroupRequest;
import com.amazonaws.services.rds.model.OptionConfiguration;
import com.amazonaws.services.rds.model.OptionSetting;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyOptionGroupRequestMarshaller
implements Marshaller<Request<ModifyOptionGroupRequest>, ModifyOptionGroupRequest> {
    @Override
    public Request<ModifyOptionGroupRequest> marshall(ModifyOptionGroupRequest modifyOptionGroupRequest) {
        SdkInternalList optionsToRemoveList;
        SdkInternalList optionsToIncludeList;
        if (modifyOptionGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyOptionGroupRequest> request = new DefaultRequest<ModifyOptionGroupRequest>(modifyOptionGroupRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyOptionGroupRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(modifyOptionGroupRequest.getOptionGroupName()));
        }
        if (!(optionsToIncludeList = (SdkInternalList)modifyOptionGroupRequest.getOptionsToInclude()).isEmpty() || !optionsToIncludeList.isAutoConstruct()) {
            int optionsToIncludeListIndex = 1;
            for (OptionConfiguration optionsToIncludeListValue : optionsToIncludeList) {
                SdkInternalList optionSettingsList;
                SdkInternalList vpcSecurityGroupMembershipsList;
                SdkInternalList dBSecurityGroupMembershipsList;
                if (optionsToIncludeListValue.getOptionName() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionName", StringUtils.fromString(optionsToIncludeListValue.getOptionName()));
                }
                if (optionsToIncludeListValue.getPort() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".Port", StringUtils.fromInteger(optionsToIncludeListValue.getPort()));
                }
                if (optionsToIncludeListValue.getOptionVersion() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionVersion", StringUtils.fromString(optionsToIncludeListValue.getOptionVersion()));
                }
                if (!(dBSecurityGroupMembershipsList = (SdkInternalList)optionsToIncludeListValue.getDBSecurityGroupMemberships()).isEmpty() || !dBSecurityGroupMembershipsList.isAutoConstruct()) {
                    int dBSecurityGroupMembershipsListIndex = 1;
                    for (Object dBSecurityGroupMembershipsListValue : dBSecurityGroupMembershipsList) {
                        if (dBSecurityGroupMembershipsListValue != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".DBSecurityGroupMemberships.DBSecurityGroupName." + dBSecurityGroupMembershipsListIndex, StringUtils.fromString((String)dBSecurityGroupMembershipsListValue));
                        }
                        ++dBSecurityGroupMembershipsListIndex;
                    }
                }
                if (!(vpcSecurityGroupMembershipsList = (SdkInternalList)optionsToIncludeListValue.getVpcSecurityGroupMemberships()).isEmpty() || !vpcSecurityGroupMembershipsList.isAutoConstruct()) {
                    Object dBSecurityGroupMembershipsListValue;
                    int vpcSecurityGroupMembershipsListIndex = 1;
                    dBSecurityGroupMembershipsListValue = vpcSecurityGroupMembershipsList.iterator();
                    while (dBSecurityGroupMembershipsListValue.hasNext()) {
                        String vpcSecurityGroupMembershipsListValue = (String)dBSecurityGroupMembershipsListValue.next();
                        if (vpcSecurityGroupMembershipsListValue != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".VpcSecurityGroupMemberships.VpcSecurityGroupId." + vpcSecurityGroupMembershipsListIndex, StringUtils.fromString(vpcSecurityGroupMembershipsListValue));
                        }
                        ++vpcSecurityGroupMembershipsListIndex;
                    }
                }
                if (!(optionSettingsList = (SdkInternalList)optionsToIncludeListValue.getOptionSettings()).isEmpty() || !optionSettingsList.isAutoConstruct()) {
                    int optionSettingsListIndex = 1;
                    for (OptionSetting optionSettingsListValue : optionSettingsList) {
                        if (optionSettingsListValue.getName() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Name", StringUtils.fromString(optionSettingsListValue.getName()));
                        }
                        if (optionSettingsListValue.getValue() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Value", StringUtils.fromString(optionSettingsListValue.getValue()));
                        }
                        if (optionSettingsListValue.getDefaultValue() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".DefaultValue", StringUtils.fromString(optionSettingsListValue.getDefaultValue()));
                        }
                        if (optionSettingsListValue.getDescription() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Description", StringUtils.fromString(optionSettingsListValue.getDescription()));
                        }
                        if (optionSettingsListValue.getApplyType() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".ApplyType", StringUtils.fromString(optionSettingsListValue.getApplyType()));
                        }
                        if (optionSettingsListValue.getDataType() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".DataType", StringUtils.fromString(optionSettingsListValue.getDataType()));
                        }
                        if (optionSettingsListValue.getAllowedValues() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".AllowedValues", StringUtils.fromString(optionSettingsListValue.getAllowedValues()));
                        }
                        if (optionSettingsListValue.getIsModifiable() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".IsModifiable", StringUtils.fromBoolean(optionSettingsListValue.getIsModifiable()));
                        }
                        if (optionSettingsListValue.getIsCollection() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".IsCollection", StringUtils.fromBoolean(optionSettingsListValue.getIsCollection()));
                        }
                        ++optionSettingsListIndex;
                    }
                }
                ++optionsToIncludeListIndex;
            }
        }
        if (!(optionsToRemoveList = (SdkInternalList)modifyOptionGroupRequest.getOptionsToRemove()).isEmpty() || !optionsToRemoveList.isAutoConstruct()) {
            int optionsToRemoveListIndex = 1;
            for (String optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex, StringUtils.fromString(optionsToRemoveListValue));
                }
                ++optionsToRemoveListIndex;
            }
        }
        if (modifyOptionGroupRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean(modifyOptionGroupRequest.getApplyImmediately()));
        }
        return request;
    }
}

