/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeEvaluationsRequestMarshaller
implements Marshaller<Request<DescribeEvaluationsRequest>, DescribeEvaluationsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeEvaluationsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeEvaluationsRequest> marshall(DescribeEvaluationsRequest describeEvaluationsRequest) {
        if (describeEvaluationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeEvaluationsRequest> request = new DefaultRequest<DescribeEvaluationsRequest>(describeEvaluationsRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.DescribeEvaluations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeEvaluationsRequest.getFilterVariable() != null) {
                jsonGenerator.writeFieldName("FilterVariable").writeValue(describeEvaluationsRequest.getFilterVariable());
            }
            if (describeEvaluationsRequest.getEQ() != null) {
                jsonGenerator.writeFieldName("EQ").writeValue(describeEvaluationsRequest.getEQ());
            }
            if (describeEvaluationsRequest.getGT() != null) {
                jsonGenerator.writeFieldName("GT").writeValue(describeEvaluationsRequest.getGT());
            }
            if (describeEvaluationsRequest.getLT() != null) {
                jsonGenerator.writeFieldName("LT").writeValue(describeEvaluationsRequest.getLT());
            }
            if (describeEvaluationsRequest.getGE() != null) {
                jsonGenerator.writeFieldName("GE").writeValue(describeEvaluationsRequest.getGE());
            }
            if (describeEvaluationsRequest.getLE() != null) {
                jsonGenerator.writeFieldName("LE").writeValue(describeEvaluationsRequest.getLE());
            }
            if (describeEvaluationsRequest.getNE() != null) {
                jsonGenerator.writeFieldName("NE").writeValue(describeEvaluationsRequest.getNE());
            }
            if (describeEvaluationsRequest.getPrefix() != null) {
                jsonGenerator.writeFieldName("Prefix").writeValue(describeEvaluationsRequest.getPrefix());
            }
            if (describeEvaluationsRequest.getSortOrder() != null) {
                jsonGenerator.writeFieldName("SortOrder").writeValue(describeEvaluationsRequest.getSortOrder());
            }
            if (describeEvaluationsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeEvaluationsRequest.getNextToken());
            }
            if (describeEvaluationsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeEvaluationsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

