/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.ApplicationUpdate;
import com.amazonaws.services.kinesisanalytics.model.InputUpdate;
import com.amazonaws.services.kinesisanalytics.model.OutputUpdate;
import com.amazonaws.services.kinesisanalytics.model.ReferenceDataSourceUpdate;
import com.amazonaws.services.kinesisanalytics.model.transform.InputUpdateJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.OutputUpdateJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.ReferenceDataSourceUpdateJsonMarshaller;
import java.util.List;

public class ApplicationUpdateJsonMarshaller {
    private static ApplicationUpdateJsonMarshaller instance;

    public void marshall(ApplicationUpdate applicationUpdate, StructuredJsonGenerator jsonGenerator) {
        if (applicationUpdate == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ReferenceDataSourceUpdate> list;
            List<OutputUpdate> outputUpdatesList;
            jsonGenerator.writeStartObject();
            List<InputUpdate> inputUpdatesList = applicationUpdate.getInputUpdates();
            if (inputUpdatesList != null) {
                jsonGenerator.writeFieldName("InputUpdates");
                jsonGenerator.writeStartArray();
                for (InputUpdate inputUpdate : inputUpdatesList) {
                    if (inputUpdate == null) continue;
                    InputUpdateJsonMarshaller.getInstance().marshall(inputUpdate, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (applicationUpdate.getApplicationCodeUpdate() != null) {
                jsonGenerator.writeFieldName("ApplicationCodeUpdate").writeValue(applicationUpdate.getApplicationCodeUpdate());
            }
            if ((outputUpdatesList = applicationUpdate.getOutputUpdates()) != null) {
                jsonGenerator.writeFieldName("OutputUpdates");
                jsonGenerator.writeStartArray();
                for (OutputUpdate outputUpdatesListValue : outputUpdatesList) {
                    if (outputUpdatesListValue == null) continue;
                    OutputUpdateJsonMarshaller.getInstance().marshall(outputUpdatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = applicationUpdate.getReferenceDataSourceUpdates()) != null) {
                jsonGenerator.writeFieldName("ReferenceDataSourceUpdates");
                jsonGenerator.writeStartArray();
                for (ReferenceDataSourceUpdate referenceDataSourceUpdatesListValue : list) {
                    if (referenceDataSourceUpdatesListValue == null) continue;
                    ReferenceDataSourceUpdateJsonMarshaller.getInstance().marshall(referenceDataSourceUpdatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApplicationUpdateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationUpdateJsonMarshaller();
        }
        return instance;
    }
}

