/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DecreaseStreamRetentionPeriodRequestMarshaller
implements Marshaller<Request<DecreaseStreamRetentionPeriodRequest>, DecreaseStreamRetentionPeriodRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DecreaseStreamRetentionPeriodRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DecreaseStreamRetentionPeriodRequest> marshall(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        if (decreaseStreamRetentionPeriodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DecreaseStreamRetentionPeriodRequest> request = new DefaultRequest<DecreaseStreamRetentionPeriodRequest>(decreaseStreamRetentionPeriodRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.DecreaseStreamRetentionPeriod");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (decreaseStreamRetentionPeriodRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(decreaseStreamRetentionPeriodRequest.getStreamName());
            }
            if (decreaseStreamRetentionPeriodRequest.getRetentionPeriodHours() != null) {
                jsonGenerator.writeFieldName("RetentionPeriodHours").writeValue(decreaseStreamRetentionPeriodRequest.getRetentionPeriodHours());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

