/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glacier.model.GlacierJobDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListJobsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<GlacierJobDescription> jobList;
    private String marker;

    public List<GlacierJobDescription> getJobList() {
        return this.jobList;
    }

    public void setJobList(Collection<GlacierJobDescription> jobList) {
        if (jobList == null) {
            this.jobList = null;
            return;
        }
        this.jobList = new ArrayList<GlacierJobDescription>(jobList);
    }

    public ListJobsResult withJobList(GlacierJobDescription ... jobList) {
        if (this.jobList == null) {
            this.setJobList(new ArrayList<GlacierJobDescription>(jobList.length));
        }
        for (GlacierJobDescription ele : jobList) {
            this.jobList.add(ele);
        }
        return this;
    }

    public ListJobsResult withJobList(Collection<GlacierJobDescription> jobList) {
        this.setJobList(jobList);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListJobsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobList() != null) {
            sb.append("JobList: " + this.getJobList() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResult)) {
            return false;
        }
        ListJobsResult other = (ListJobsResult)obj;
        if (other.getJobList() == null ^ this.getJobList() == null) {
            return false;
        }
        if (other.getJobList() != null && !other.getJobList().equals(this.getJobList())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobList() == null ? 0 : this.getJobList().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListJobsResult clone() {
        try {
            return (ListJobsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

