/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeHostReservationOfferingsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHostReservationOfferingsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationOfferingsRequest>, DescribeHostReservationOfferingsRequest> {
    @Override
    public Request<DescribeHostReservationOfferingsRequest> marshall(DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest) {
        SdkInternalList filterList;
        if (describeHostReservationOfferingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeHostReservationOfferingsRequest> request = new DefaultRequest<DescribeHostReservationOfferingsRequest>(describeHostReservationOfferingsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeHostReservationOfferings");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHostReservationOfferingsRequest.getOfferingId() != null) {
            request.addParameter("OfferingId", StringUtils.fromString(describeHostReservationOfferingsRequest.getOfferingId()));
        }
        if (describeHostReservationOfferingsRequest.getMinDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromInteger(describeHostReservationOfferingsRequest.getMinDuration()));
        }
        if (describeHostReservationOfferingsRequest.getMaxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromInteger(describeHostReservationOfferingsRequest.getMaxDuration()));
        }
        if (!(filterList = (SdkInternalList)describeHostReservationOfferingsRequest.getFilter()).isEmpty() || !filterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter filterListValue : filterList) {
                SdkInternalList valuesList;
                if (filterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString(filterListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filterListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeHostReservationOfferingsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeHostReservationOfferingsRequest.getMaxResults()));
        }
        if (describeHostReservationOfferingsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeHostReservationOfferingsRequest.getNextToken()));
        }
        return request;
    }
}

