/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import java.lang.reflect.Method;

@SdkInternalApi
final class StandardMethodReflects {
    StandardMethodReflects() {
    }

    static final <T, V> DynamoDBMapperFieldModel.Reflect<T, V> of(Method getter) {
        Method setter = null;
        try {
            String name = "set" + getter.getName().replaceFirst("^(get|is)", "");
            setter = getter.getDeclaringClass().getMethod(name, getter.getReturnType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new MethodReflect(getter, setter);
    }

    static final <T, V> DynamoDBMapperFieldModel.Reflect<T, V> of(Method getter, DynamoDBMapperFieldModel.Reflect<T, T> declaring, Class<T> targetType) {
        DynamoDBMapperFieldModel.Reflect<T, V> reflect = StandardMethodReflects.of(getter);
        return new DeclaringReflect(reflect, declaring, targetType);
    }

    static final class DeclaringReflect<T, V>
    implements DynamoDBMapperFieldModel.Reflect<T, V> {
        private final DynamoDBMapperFieldModel.Reflect<T, V> reflect;
        private final DynamoDBMapperFieldModel.Reflect<T, T> declaring;
        private final Class<T> targetType;

        private DeclaringReflect(DynamoDBMapperFieldModel.Reflect<T, V> reflect, DynamoDBMapperFieldModel.Reflect<T, T> declaring, Class<T> targetType) {
            this.reflect = reflect;
            this.declaring = declaring;
            this.targetType = targetType;
        }

        @Override
        public final V get(T object) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                return null;
            }
            return this.reflect.get(declaringObject);
        }

        @Override
        public final void set(T object, V value) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                try {
                    declaringObject = this.targetType.newInstance();
                }
                catch (Exception e) {
                    throw new DynamoDBMappingException("could not instantiate " + this.targetType, e);
                }
                this.declaring.set(object, declaringObject);
            }
            this.reflect.set(declaringObject, value);
        }
    }

    static final class MethodReflect<T, V>
    implements DynamoDBMapperFieldModel.Reflect<T, V> {
        private final Method getter;
        private final Method setter;

        private MethodReflect(Method getter, Method setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public V get(T object) {
            try {
                return (V)this.getter.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.getter + " on " + object.getClass(), e);
            }
        }

        @Override
        public void set(T object, V value) {
            try {
                this.setter.invoke(object, value);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.setter + " on " + object.getClass(), e);
            }
        }
    }
}

