/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAttributeTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardParameterTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class StandardConverterRules {
    private static final Log LOG = LogFactory.getLog(StandardConverterRules.class);

    StandardConverterRules() {
    }

    static final <V> RuleFactory<V> of(DynamoDBMapperConfig config, S3Link.Factory s3Links, DynamoDBMapperModelFactory.Factory models) {
        Rules factory = new Rules(StandardTypeConverters.factory().override().with(String.class, S3Link.class, s3Links).build());
        if (config.getConversionSchema() == ConversionSchemas.V1) {
            Rules rules = factory;
            rules.getClass();
            factory.with(rules.new Rules.NativeBool(true));
            Rules rules2 = factory;
            rules2.getClass();
            factory.with(rules2.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.S));
            Rules rules3 = factory;
            rules3.getClass();
            factory.with(rules3.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.N));
            Rules rules4 = factory;
            rules4.getClass();
            factory.with(rules4.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.B));
            Rules rules5 = factory;
            rules5.getClass();
            factory.with(rules5.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.SS));
            Rules rules6 = factory;
            rules6.getClass();
            factory.with(rules6.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.NS));
            Rules rules7 = factory;
            rules7.getClass();
            factory.with(rules7.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.BS));
            Rules rules8 = factory;
            rules8.getClass();
            factory.with(rules8.new Rules.ObjectStringSet());
        } else if (config.getConversionSchema() == ConversionSchemas.V2) {
            Rules rules = factory;
            rules.getClass();
            factory.with(rules.new Rules.NativeBool(false));
            Rules rules9 = factory;
            rules9.getClass();
            factory.with(rules9.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.S));
            Rules rules10 = factory;
            rules10.getClass();
            factory.with(rules10.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.N));
            Rules rules11 = factory;
            rules11.getClass();
            factory.with(rules11.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.B));
            Rules rules12 = factory;
            rules12.getClass();
            factory.with(rules12.new Rules.NativeBoolSet());
            Rules rules13 = factory;
            rules13.getClass();
            factory.with(rules13.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.SS));
            Rules rules14 = factory;
            rules14.getClass();
            factory.with(rules14.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.NS));
            Rules rules15 = factory;
            rules15.getClass();
            factory.with(rules15.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.BS));
            Rules rules16 = factory;
            rules16.getClass();
            factory.with(rules16.new Rules.ObjectSet());
            Rules rules17 = factory;
            rules17.getClass();
            factory.with(rules17.new Rules.ObjectList());
            Rules rules18 = factory;
            rules18.getClass();
            factory.with(rules18.new Rules.ObjectMap());
            Rules rules19 = factory;
            rules19.getClass();
            factory.with(rules19.new Rules.DocumentObjectMap(config, models));
        } else {
            Rules rules = factory;
            rules.getClass();
            factory.with(rules.new Rules.NativeBool(true));
            Rules rules20 = factory;
            rules20.getClass();
            factory.with(rules20.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.S));
            Rules rules21 = factory;
            rules21.getClass();
            factory.with(rules21.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.N));
            Rules rules22 = factory;
            rules22.getClass();
            factory.with(rules22.new Rules.SimpleScalar(StandardAttributeTypes.AttributeType.B));
            Rules rules23 = factory;
            rules23.getClass();
            factory.with(rules23.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.SS));
            Rules rules24 = factory;
            rules24.getClass();
            factory.with(rules24.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.NS));
            Rules rules25 = factory;
            rules25.getClass();
            factory.with(rules25.new Rules.SimpleScalarSet(StandardAttributeTypes.AttributeType.BS));
            Rules rules26 = factory;
            rules26.getClass();
            factory.with(rules26.new Rules.ObjectStringSet());
            Rules rules27 = factory;
            rules27.getClass();
            factory.with(rules27.new Rules.ObjectList());
            Rules rules28 = factory;
            rules28.getClass();
            factory.with(rules28.new Rules.ObjectMap());
            Rules rules29 = factory;
            rules29.getClass();
            factory.with(rules29.new Rules.DocumentObjectMap(config, models));
        }
        return factory;
    }

    static interface RuleFactory<V> {
        public Rule<V> getRule(StandardBeanProperties.Bean<?, V> var1);
    }

    static interface Rule<V> {
        public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> var1, DynamoDBMapperFieldModel.Properties<?, ?> var2);

        public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> var1);

        public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType();
    }

    private static final class Rules<V>
    implements RuleFactory<V> {
        private final Set<Rule<V>> rules = new LinkedHashSet<Rule<V>>();
        private final DynamoDBTypeConverterFactory scalars;

        private Rules(DynamoDBTypeConverterFactory scalars) {
            this.scalars = scalars;
        }

        private Rules<V> with(Rule<?> rule) {
            this.rules.add(rule);
            return this;
        }

        private Rule<V> getRule(StandardParameterTypes.ParamType<V> type, DynamoDBMapperFieldModel.Properties<?, V> props) {
            if (props.typeConverter() != null) {
                return new CustomTypeConverted(props);
            }
            for (Rule<V> rule : this.rules) {
                if (!rule.isAssignableFrom(type, props)) continue;
                return rule;
            }
            return new NotSupported();
        }

        @Override
        public Rule<V> getRule(StandardBeanProperties.Bean<?, V> bean) {
            return this.getRule(bean.type(), bean);
        }

        private final class NotSupported
        implements Rule<V> {
            private NotSupported() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(final StandardParameterTypes.ParamType<V> type) {
                return new DynamoDBTypeConverter<AttributeValue, V>(){

                    @Override
                    public final AttributeValue convert(V o) {
                        throw new DynamoDBMappingException("type " + type + " is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                    }

                    @Override
                    public final V unconvert(AttributeValue o) {
                        throw new DynamoDBMappingException("type " + type + " is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                    }
                };
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.NULL.attributeType();
            }
        }

        private final class DocumentObjectMap
        implements Rule<V> {
            private final DynamoDBMapperModelFactory.Factory models;
            private final DynamoDBMapperConfig config;

            private DocumentObjectMap(DynamoDBMapperConfig config, DynamoDBMapperModelFactory.Factory models) {
                this.models = models;
                this.config = config;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardBeanProperties.of(type.type()).annotations().document() != null;
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(final StandardParameterTypes.ParamType<V> type) {
                return StandardAttributeTypes.AttributeType.M.join(new DynamoDBTypeConverter<Map<String, AttributeValue>, V>(){

                    @Override
                    public final Map<String, AttributeValue> convert(V o) {
                        return DocumentObjectMap.this.models.getModelFactory(DocumentObjectMap.this.config).getTableModel(type.type()).convert(o);
                    }

                    @Override
                    public final V unconvert(Map<String, AttributeValue> o) {
                        return DocumentObjectMap.this.models.getModelFactory(DocumentObjectMap.this.config).getTableModel(type.type()).unconvert(o);
                    }
                });
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.M.attributeType();
            }
        }

        private final class ObjectMap
        implements Rule<Map<String, V>> {
            private ObjectMap() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.MAP.is(type.type()) && type.param(1) != null && StandardTypeConverters.Scalar.STRING.is(type.param(0).type());
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Map<String, V>> newConverter(StandardParameterTypes.ParamType<Map<String, V>> type) {
                Rule rule = Rules.this.getRule(type.param(1), DynamoDBMapperFieldModel.Properties.Immutable.empty());
                DynamoDBTypeConverter target = StandardAttributeTypes.AttributeType.NULL.join(rule.newConverter(type.param(1)));
                return StandardAttributeTypes.AttributeType.M.join(StandardTypeConverters.Vector.MAP.join(target));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.M.attributeType();
            }
        }

        private final class ObjectList
        implements Rule<List<V>> {
            private ObjectList() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.LIST.is(type.type()) && type.param(0) != null;
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, List<V>> newConverter(StandardParameterTypes.ParamType<List<V>> type) {
                Rule rule = Rules.this.getRule(type.param(0), DynamoDBMapperFieldModel.Properties.Immutable.empty());
                DynamoDBTypeConverter target = StandardAttributeTypes.AttributeType.NULL.join(rule.newConverter(type.param(0)));
                return StandardAttributeTypes.AttributeType.L.join(StandardTypeConverters.Vector.LIST.join(target));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.L.attributeType();
            }
        }

        private final class ObjectSet
        implements Rule<Collection<V>> {
            private ObjectSet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.SET.is(type.type()) && type.param(0) != null;
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                Rule rule = Rules.this.getRule(type.param(0), DynamoDBMapperFieldModel.Properties.Immutable.empty());
                DynamoDBTypeConverter target = StandardAttributeTypes.AttributeType.NULL.join(rule.newConverter(type.param(0)));
                return StandardAttributeTypes.AttributeType.L.join(StandardTypeConverters.Vector.SET.join(target));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.L.attributeType();
            }
        }

        private final class NativeBoolSet
        implements Rule<Collection<V>> {
            private NativeBoolSet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.SET.is(type.type()) && StandardTypeConverters.Scalar.BOOLEAN.is(type.param(0).type());
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                return StandardTypeConverters.join(new DynamoDBTypeConverter<AttributeValue, List<AttributeValue>>(){

                    @Override
                    public final AttributeValue convert(List<AttributeValue> o) {
                        return StandardAttributeTypes.AttributeType.L.convert(o);
                    }

                    @Override
                    public final List<AttributeValue> unconvert(AttributeValue o) {
                        if (o.getL() == null && o.getNS() != null) {
                            return StandardTypeConverters.Vector.LIST.convert(o.getNS(), StandardAttributeTypes.AttributeType.BOOL.join(StandardTypeConverters.Scalar.BOOLEAN.join(String.class)));
                        }
                        return (List)StandardAttributeTypes.AttributeType.L.unconvert(o);
                    }
                }, StandardTypeConverters.Vector.SET.join(StandardAttributeTypes.AttributeType.NULL.join(StandardAttributeTypes.AttributeType.BOOL.join(StandardTypeConverters.Scalar.BOOLEAN.join(type.param(0).type())))));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.L.attributeType();
            }
        }

        private final class ObjectStringSet
        implements Rule<Collection<V>> {
            private ObjectStringSet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.SET.is(type.type());
                }
                return false;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                LOG.warn((Object)"Marshaling a set of non-String objects to a DynamoDB StringSet. You won't be able to read these objects back out of DynamoDB unless you REALLY know what you're doing: it's probably a bug. If you DO know what you're doing feel to ignore this warning, but consider using a custom @DynamoDBTypeConverted/DynamoDBTypeConverter for this instead.");
                return StandardAttributeTypes.AttributeType.SS.join(StandardTypeConverters.Vector.SET.join(StandardTypeConverters.Scalar.STRING.join(StandardTypeConverters.Scalar.DEFAULT.type())));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.SS.attributeType();
            }
        }

        private final class SimpleScalarSet
        implements Rule<Collection<V>> {
            private final StandardAttributeTypes.AttributeType attribute;
            private final Class<V> sourceType;

            private SimpleScalarSet(StandardAttributeTypes.AttributeType attribute) {
                this.sourceType = (attribute == StandardAttributeTypes.AttributeType.BS ? StandardTypeConverters.Scalar.BYTE_BUFFER : StandardTypeConverters.Scalar.STRING).type();
                this.attribute = attribute;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return StandardTypeConverters.Vector.SET.is(type.type()) && type.param(0).scalar().is(this.attribute.scalarAttributeType());
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, Collection<V>> newConverter(StandardParameterTypes.ParamType<Collection<V>> type) {
                DynamoDBTypeConverter target = Rules.this.scalars.getConverter(this.sourceType, type.param(0).type());
                return this.attribute.join(StandardTypeConverters.Vector.SET.join(target));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.attribute.attributeType();
            }
        }

        private final class SimpleScalar
        implements Rule<V> {
            private final StandardAttributeTypes.AttributeType attribute;
            private final Class<V> sourceType;

            private SimpleScalar(StandardAttributeTypes.AttributeType attribute) {
                this.sourceType = (attribute == StandardAttributeTypes.AttributeType.B ? StandardTypeConverters.Scalar.BYTE_BUFFER : StandardTypeConverters.Scalar.STRING).type();
                this.attribute = attribute;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return !StandardTypeConverters.Vector.SET.is(type.type()) && type.scalar().is(this.attribute.scalarAttributeType());
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> type) {
                DynamoDBTypeConverter target = Rules.this.scalars.getConverter(this.sourceType, type.type());
                return this.attribute.join(target);
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.attribute.attributeType();
            }
        }

        private final class NativeBool
        implements Rule<V> {
            private final boolean onlyIfOverride;

            private NativeBool(boolean onlyIfOverride) {
                this.onlyIfOverride = onlyIfOverride;
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                if (props.attributeType() == null) {
                    return !this.onlyIfOverride && !StandardTypeConverters.Vector.SET.is(type.type()) && StandardTypeConverters.Scalar.BOOLEAN.is(type.type());
                }
                return props.attributeType() == this.getAttributeType();
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> type) {
                return StandardAttributeTypes.AttributeType.BOOL.join(StandardTypeConverters.Scalar.BOOLEAN.join(type.type()));
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return StandardAttributeTypes.AttributeType.BOOL.attributeType();
            }
        }

        private final class CustomTypeConverted
        implements Rule<V> {
            private final DynamoDBTypeConverter<V, V> target;
            private final StandardParameterTypes.ParamType<V> sourceType;
            private final Rule<V> rule;

            private CustomTypeConverted(DynamoDBMapperFieldModel.Properties<?, V> props) {
                this.target = props.typeConverter();
                this.sourceType = StandardParameterTypes.of(this.target);
                this.rule = Rules.this.getRule(this.sourceType, new DynamoDBMapperFieldModel.Properties.Buildable(props).withTypeConverter(null));
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Properties<?, ?> props) {
                return true;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, V> newConverter(StandardParameterTypes.ParamType<V> type) {
                DynamoDBTypeConverter source = this.rule.newConverter(this.sourceType);
                return StandardTypeConverters.join(source, this.target);
            }

            @Override
            public DynamoDBMapperFieldModel.DynamoDBAttributeType getAttributeType() {
                return this.rule.getAttributeType();
            }
        }
    }
}

