/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.ImportApiKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;

public class ImportApiKeysRequestMarshaller
implements Marshaller<Request<ImportApiKeysRequest>, ImportApiKeysRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ImportApiKeysRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ImportApiKeysRequest> marshall(ImportApiKeysRequest importApiKeysRequest) {
        if (importApiKeysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportApiKeysRequest> request = new DefaultRequest<ImportApiKeysRequest>(importApiKeysRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/apikeys?mode=import";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (importApiKeysRequest.getFormat() != null) {
            request.addParameter("format", StringUtils.fromString(importApiKeysRequest.getFormat()));
        }
        if (importApiKeysRequest.getFailOnWarnings() != null) {
            request.addParameter("failonwarnings", StringUtils.fromBoolean(importApiKeysRequest.getFailOnWarnings()));
        }
        request.setContent(BinaryUtils.toStream(importApiKeysRequest.getBody()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

