/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListActivityTypesRequestMarshaller
implements Marshaller<Request<ListActivityTypesRequest>, ListActivityTypesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListActivityTypesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListActivityTypesRequest> marshall(ListActivityTypesRequest listActivityTypesRequest) {
        if (listActivityTypesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListActivityTypesRequest> request = new DefaultRequest<ListActivityTypesRequest>(listActivityTypesRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.ListActivityTypes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listActivityTypesRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(listActivityTypesRequest.getDomain());
            }
            if (listActivityTypesRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(listActivityTypesRequest.getName());
            }
            if (listActivityTypesRequest.getRegistrationStatus() != null) {
                jsonGenerator.writeFieldName("registrationStatus").writeValue(listActivityTypesRequest.getRegistrationStatus());
            }
            if (listActivityTypesRequest.getNextPageToken() != null) {
                jsonGenerator.writeFieldName("nextPageToken").writeValue(listActivityTypesRequest.getNextPageToken());
            }
            if (listActivityTypesRequest.getMaximumPageSize() != null) {
                jsonGenerator.writeFieldName("maximumPageSize").writeValue(listActivityTypesRequest.getMaximumPageSize());
            }
            if (listActivityTypesRequest.getReverseOrder() != null) {
                jsonGenerator.writeFieldName("reverseOrder").writeValue(listActivityTypesRequest.getReverseOrder());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

