/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.AbortVaultLockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class AbortVaultLockRequestMarshaller
implements Marshaller<Request<AbortVaultLockRequest>, AbortVaultLockRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AbortVaultLockRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AbortVaultLockRequest> marshall(AbortVaultLockRequest abortVaultLockRequest) {
        if (abortVaultLockRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AbortVaultLockRequest> request = new DefaultRequest<AbortVaultLockRequest>(abortVaultLockRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/lock-policy";
        uriResourcePath = uriResourcePath.replace("{accountId}", abortVaultLockRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(abortVaultLockRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", abortVaultLockRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(abortVaultLockRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

