/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeChangeSetRequestMarshaller
implements Marshaller<Request<DescribeChangeSetRequest>, DescribeChangeSetRequest> {
    @Override
    public Request<DescribeChangeSetRequest> marshall(DescribeChangeSetRequest describeChangeSetRequest) {
        if (describeChangeSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeChangeSetRequest> request = new DefaultRequest<DescribeChangeSetRequest>(describeChangeSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DescribeChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeChangeSetRequest.getChangeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString(describeChangeSetRequest.getChangeSetName()));
        }
        if (describeChangeSetRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(describeChangeSetRequest.getStackName()));
        }
        if (describeChangeSetRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeChangeSetRequest.getNextToken()));
        }
        return request;
    }
}

