/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateChapCredentialsRequestMarshaller
implements Marshaller<Request<UpdateChapCredentialsRequest>, UpdateChapCredentialsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateChapCredentialsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateChapCredentialsRequest> marshall(UpdateChapCredentialsRequest updateChapCredentialsRequest) {
        if (updateChapCredentialsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateChapCredentialsRequest> request = new DefaultRequest<UpdateChapCredentialsRequest>(updateChapCredentialsRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.UpdateChapCredentials");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateChapCredentialsRequest.getTargetARN() != null) {
                jsonGenerator.writeFieldName("TargetARN").writeValue(updateChapCredentialsRequest.getTargetARN());
            }
            if (updateChapCredentialsRequest.getSecretToAuthenticateInitiator() != null) {
                jsonGenerator.writeFieldName("SecretToAuthenticateInitiator").writeValue(updateChapCredentialsRequest.getSecretToAuthenticateInitiator());
            }
            if (updateChapCredentialsRequest.getInitiatorName() != null) {
                jsonGenerator.writeFieldName("InitiatorName").writeValue(updateChapCredentialsRequest.getInitiatorName());
            }
            if (updateChapCredentialsRequest.getSecretToAuthenticateTarget() != null) {
                jsonGenerator.writeFieldName("SecretToAuthenticateTarget").writeValue(updateChapCredentialsRequest.getSecretToAuthenticateTarget());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

