/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.machinelearning.model.MLModel;
import com.amazonaws.services.machinelearning.model.transform.RealtimeEndpointInfoJsonMarshaller;
import java.util.Map;

public class MLModelJsonMarshaller {
    private static MLModelJsonMarshaller instance;

    public void marshall(MLModel mLModel, StructuredJsonGenerator jsonGenerator) {
        if (mLModel == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap trainingParametersMap;
            jsonGenerator.writeStartObject();
            if (mLModel.getMLModelId() != null) {
                jsonGenerator.writeFieldName("MLModelId").writeValue(mLModel.getMLModelId());
            }
            if (mLModel.getTrainingDataSourceId() != null) {
                jsonGenerator.writeFieldName("TrainingDataSourceId").writeValue(mLModel.getTrainingDataSourceId());
            }
            if (mLModel.getCreatedByIamUser() != null) {
                jsonGenerator.writeFieldName("CreatedByIamUser").writeValue(mLModel.getCreatedByIamUser());
            }
            if (mLModel.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(mLModel.getCreatedAt());
            }
            if (mLModel.getLastUpdatedAt() != null) {
                jsonGenerator.writeFieldName("LastUpdatedAt").writeValue(mLModel.getLastUpdatedAt());
            }
            if (mLModel.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(mLModel.getName());
            }
            if (mLModel.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(mLModel.getStatus());
            }
            if (mLModel.getSizeInBytes() != null) {
                jsonGenerator.writeFieldName("SizeInBytes").writeValue(mLModel.getSizeInBytes());
            }
            if (mLModel.getEndpointInfo() != null) {
                jsonGenerator.writeFieldName("EndpointInfo");
                RealtimeEndpointInfoJsonMarshaller.getInstance().marshall(mLModel.getEndpointInfo(), jsonGenerator);
            }
            if (!(trainingParametersMap = (SdkInternalMap)mLModel.getTrainingParameters()).isEmpty() || !trainingParametersMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TrainingParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry trainingParametersMapValue : trainingParametersMap.entrySet()) {
                    if (trainingParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)trainingParametersMapValue.getKey());
                    jsonGenerator.writeValue((String)trainingParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (mLModel.getInputDataLocationS3() != null) {
                jsonGenerator.writeFieldName("InputDataLocationS3").writeValue(mLModel.getInputDataLocationS3());
            }
            if (mLModel.getAlgorithm() != null) {
                jsonGenerator.writeFieldName("Algorithm").writeValue(mLModel.getAlgorithm());
            }
            if (mLModel.getMLModelType() != null) {
                jsonGenerator.writeFieldName("MLModelType").writeValue(mLModel.getMLModelType());
            }
            if (mLModel.getScoreThreshold() != null) {
                jsonGenerator.writeFieldName("ScoreThreshold").writeValue(mLModel.getScoreThreshold().floatValue());
            }
            if (mLModel.getScoreThresholdLastUpdatedAt() != null) {
                jsonGenerator.writeFieldName("ScoreThresholdLastUpdatedAt").writeValue(mLModel.getScoreThresholdLastUpdatedAt());
            }
            if (mLModel.getMessage() != null) {
                jsonGenerator.writeFieldName("Message").writeValue(mLModel.getMessage());
            }
            if (mLModel.getComputeTime() != null) {
                jsonGenerator.writeFieldName("ComputeTime").writeValue(mLModel.getComputeTime());
            }
            if (mLModel.getFinishedAt() != null) {
                jsonGenerator.writeFieldName("FinishedAt").writeValue(mLModel.getFinishedAt());
            }
            if (mLModel.getStartedAt() != null) {
                jsonGenerator.writeFieldName("StartedAt").writeValue(mLModel.getStartedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MLModelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MLModelJsonMarshaller();
        }
        return instance;
    }
}

