/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.services.glacier.model.transform.InventoryRetrievalJobInputJsonMarshaller;

public class JobParametersJsonMarshaller {
    private static JobParametersJsonMarshaller instance;

    public void marshall(JobParameters jobParameters, StructuredJsonGenerator jsonGenerator) {
        if (jobParameters == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (jobParameters.getFormat() != null) {
                jsonGenerator.writeFieldName("Format").writeValue(jobParameters.getFormat());
            }
            if (jobParameters.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(jobParameters.getType());
            }
            if (jobParameters.getArchiveId() != null) {
                jsonGenerator.writeFieldName("ArchiveId").writeValue(jobParameters.getArchiveId());
            }
            if (jobParameters.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(jobParameters.getDescription());
            }
            if (jobParameters.getSNSTopic() != null) {
                jsonGenerator.writeFieldName("SNSTopic").writeValue(jobParameters.getSNSTopic());
            }
            if (jobParameters.getRetrievalByteRange() != null) {
                jsonGenerator.writeFieldName("RetrievalByteRange").writeValue(jobParameters.getRetrievalByteRange());
            }
            if (jobParameters.getInventoryRetrievalParameters() != null) {
                jsonGenerator.writeFieldName("InventoryRetrievalParameters");
                InventoryRetrievalJobInputJsonMarshaller.getInstance().marshall(jobParameters.getInventoryRetrievalParameters(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobParametersJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobParametersJsonMarshaller();
        }
        return instance;
    }
}

