/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directory.model.IpRoute;

public class IpRouteJsonMarshaller {
    private static IpRouteJsonMarshaller instance;

    public void marshall(IpRoute ipRoute, StructuredJsonGenerator jsonGenerator) {
        if (ipRoute == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (ipRoute.getCidrIp() != null) {
                jsonGenerator.writeFieldName("CidrIp").writeValue(ipRoute.getCidrIp());
            }
            if (ipRoute.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(ipRoute.getDescription());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IpRouteJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IpRouteJsonMarshaller();
        }
        return instance;
    }
}

