/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.certificatemanager.model.DomainValidationOption;
import com.amazonaws.services.certificatemanager.model.RequestCertificateRequest;
import com.amazonaws.services.certificatemanager.model.transform.DomainValidationOptionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class RequestCertificateRequestMarshaller
implements Marshaller<Request<RequestCertificateRequest>, RequestCertificateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RequestCertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RequestCertificateRequest> marshall(RequestCertificateRequest requestCertificateRequest) {
        if (requestCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RequestCertificateRequest> request = new DefaultRequest<RequestCertificateRequest>(requestCertificateRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.RequestCertificate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<DomainValidationOption> domainValidationOptionsList;
            List<String> subjectAlternativeNamesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (requestCertificateRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(requestCertificateRequest.getDomainName());
            }
            if ((subjectAlternativeNamesList = requestCertificateRequest.getSubjectAlternativeNames()) != null) {
                jsonGenerator.writeFieldName("SubjectAlternativeNames");
                jsonGenerator.writeStartArray();
                for (String string : subjectAlternativeNamesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (requestCertificateRequest.getIdempotencyToken() != null) {
                jsonGenerator.writeFieldName("IdempotencyToken").writeValue(requestCertificateRequest.getIdempotencyToken());
            }
            if ((domainValidationOptionsList = requestCertificateRequest.getDomainValidationOptions()) != null) {
                jsonGenerator.writeFieldName("DomainValidationOptions");
                jsonGenerator.writeStartArray();
                for (DomainValidationOption domainValidationOptionsListValue : domainValidationOptionsList) {
                    if (domainValidationOptionsListValue == null) continue;
                    DomainValidationOptionJsonMarshaller.getInstance().marshall(domainValidationOptionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

