/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ArtifactRevisionInformation;
import com.amazonaws.services.codepipeline.model.PipelineExecution;
import com.amazonaws.services.codepipeline.model.transform.ArtifactRevisionInformationJsonMarshaller;
import java.util.List;

public class PipelineExecutionJsonMarshaller {
    private static PipelineExecutionJsonMarshaller instance;

    public void marshall(PipelineExecution pipelineExecution, StructuredJsonGenerator jsonGenerator) {
        if (pipelineExecution == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ArtifactRevisionInformation> artifactRevisionInformationsList;
            jsonGenerator.writeStartObject();
            if (pipelineExecution.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(pipelineExecution.getPipelineName());
            }
            if (pipelineExecution.getPipelineVersion() != null) {
                jsonGenerator.writeFieldName("pipelineVersion").writeValue(pipelineExecution.getPipelineVersion());
            }
            if (pipelineExecution.getPipelineExecutionId() != null) {
                jsonGenerator.writeFieldName("pipelineExecutionId").writeValue(pipelineExecution.getPipelineExecutionId());
            }
            if (pipelineExecution.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(pipelineExecution.getStatus());
            }
            if ((artifactRevisionInformationsList = pipelineExecution.getArtifactRevisionInformations()) != null) {
                jsonGenerator.writeFieldName("artifactRevisionInformations");
                jsonGenerator.writeStartArray();
                for (ArtifactRevisionInformation artifactRevisionInformationsListValue : artifactRevisionInformationsList) {
                    if (artifactRevisionInformationsListValue == null) continue;
                    ArtifactRevisionInformationJsonMarshaller.getInstance().marshall(artifactRevisionInformationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineExecutionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineExecutionJsonMarshaller();
        }
        return instance;
    }
}

