/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticsearch.model.ListTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListTagsRequestMarshaller
implements Marshaller<Request<ListTagsRequest>, ListTagsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListTagsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListTagsRequest> marshall(ListTagsRequest listTagsRequest) {
        if (listTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTagsRequest> request = new DefaultRequest<ListTagsRequest>(listTagsRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-01-01/tags/";
        request.setResourcePath(uriResourcePath);
        if (listTagsRequest.getARN() != null) {
            request.addParameter("arn", StringUtils.fromString(listTagsRequest.getARN()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

