/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DynamoDBMapperTableModel<T>
implements DynamoDBTypeConverter<Map<String, AttributeValue>, T> {
    private final Map<String, GlobalSecondaryIndex> globalSecondaryIndexes;
    private final Map<String, LocalSecondaryIndex> localSecondaryIndexes;
    private final Map<String, DynamoDBMapperFieldModel<T, Object>> fields;
    private final Map<KeyType, DynamoDBMapperFieldModel<T, Object>> keys;
    private final Properties<T> properties;

    private DynamoDBMapperTableModel(Builder<T> builder) {
        this.properties = new Properties.Immutable(builder);
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes();
        this.localSecondaryIndexes = builder.localSecondaryIndexes();
        this.fields = Collections.unmodifiableMap(((Builder)builder).fields);
        this.keys = Collections.unmodifiableMap(((Builder)builder).keys);
    }

    final Id<T> id() {
        return this.properties.id();
    }

    public Class<T> targetType() {
        return this.properties.targetType();
    }

    public Collection<DynamoDBMapperFieldModel<T, Object>> fields() {
        return this.fields.values();
    }

    public <V> DynamoDBMapperFieldModel<T, V> field(String attributeName) {
        if (!this.fields.containsKey(attributeName)) {
            throw new DynamoDBMappingException(this.id().err("does not map %s on model", attributeName));
        }
        return this.fields.get(attributeName);
    }

    public <V> DynamoDBMapperFieldModel<T, V> field(KeyType keyType) {
        if (!this.keys.containsKey((Object)keyType)) {
            throw new DynamoDBMappingException(this.id().err("does not map %s key on model", new Object[]{keyType}));
        }
        return this.keys.get((Object)keyType);
    }

    public Collection<DynamoDBMapperFieldModel<T, Object>> keys() {
        return this.keys.values();
    }

    public <H> DynamoDBMapperFieldModel<T, H> hashKey() {
        return this.field(KeyType.HASH);
    }

    public <R> DynamoDBMapperFieldModel<T, R> rangeKey() {
        return this.field(KeyType.RANGE);
    }

    public <R> DynamoDBMapperFieldModel<T, R> rangeKeyIfExists() {
        return this.keys.get((Object)KeyType.RANGE);
    }

    public Collection<GlobalSecondaryIndex> globalSecondaryIndexes() {
        if (this.globalSecondaryIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GlobalSecondaryIndex> copies = new ArrayList<GlobalSecondaryIndex>(this.globalSecondaryIndexes.size());
        for (String indexName : this.globalSecondaryIndexes.keySet()) {
            copies.add(this.globalSecondaryIndex(indexName));
        }
        return copies;
    }

    public GlobalSecondaryIndex globalSecondaryIndex(String indexName) {
        if (!this.globalSecondaryIndexes.containsKey(indexName)) {
            return null;
        }
        GlobalSecondaryIndex gsi = this.globalSecondaryIndexes.get(indexName);
        GlobalSecondaryIndex copy = new GlobalSecondaryIndex().withIndexName(gsi.getIndexName());
        copy.withProjection(new Projection().withProjectionType(gsi.getProjection().getProjectionType()));
        for (KeySchemaElement key : gsi.getKeySchema()) {
            copy.withKeySchema(new KeySchemaElement(key.getAttributeName(), key.getKeyType()));
        }
        return copy;
    }

    public Collection<LocalSecondaryIndex> localSecondaryIndexes() {
        if (this.localSecondaryIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocalSecondaryIndex> copies = new ArrayList<LocalSecondaryIndex>(this.localSecondaryIndexes.size());
        for (String indexName : this.localSecondaryIndexes.keySet()) {
            copies.add(this.localSecondaryIndex(indexName));
        }
        return copies;
    }

    public LocalSecondaryIndex localSecondaryIndex(String indexName) {
        if (!this.localSecondaryIndexes.containsKey(indexName)) {
            return null;
        }
        LocalSecondaryIndex lsi = this.localSecondaryIndexes.get(indexName);
        LocalSecondaryIndex copy = new LocalSecondaryIndex().withIndexName(lsi.getIndexName());
        copy.withProjection(new Projection().withProjectionType(lsi.getProjection().getProjectionType()));
        for (KeySchemaElement key : lsi.getKeySchema()) {
            copy.withKeySchema(new KeySchemaElement(key.getAttributeName(), key.getKeyType()));
        }
        return copy;
    }

    @Override
    public Map<String, AttributeValue> convert(T object) {
        LinkedHashMap<String, AttributeValue> map = new LinkedHashMap<String, AttributeValue>();
        for (DynamoDBMapperFieldModel<T, Object> field : this.fields()) {
            AttributeValue value = field.getAndConvert(object);
            if (value == null) continue;
            map.put(field.name(), value);
        }
        return map;
    }

    @Override
    public T unconvert(Map<String, AttributeValue> object) {
        T result;
        try {
            result = this.targetType().newInstance();
        }
        catch (Exception e) {
            throw new DynamoDBMappingException(this.id().err("could not instantiate %s", this.targetType()));
        }
        if (!object.isEmpty()) {
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields()) {
                AttributeValue value = object.get(field.name());
                if (value == null) continue;
                field.unconvertAndSet(result, value);
            }
        }
        return result;
    }

    public Map<String, AttributeValue> convertKey(T object) {
        LinkedHashMap<String, AttributeValue> key = new LinkedHashMap<String, AttributeValue>(4);
        for (DynamoDBMapperFieldModel<T, Object> field : this.keys()) {
            AttributeValue value = field.getAndConvert(object);
            if (value == null) continue;
            key.put(field.name(), value);
        }
        if (key.isEmpty()) {
            throw new DynamoDBMappingException(this.id().err("no key value(s) present", new Object[0]));
        }
        return key;
    }

    public <H, R> Map<String, AttributeValue> convertKey(H hashKey, R rangeKey) {
        LinkedHashMap<String, AttributeValue> key = new LinkedHashMap<String, AttributeValue>(4);
        if (hashKey != null) {
            DynamoDBMapperFieldModel<T, H> hk = this.hashKey();
            key.put(hk.name(), (AttributeValue)hk.convert((Object)hashKey));
        }
        if (rangeKey != null) {
            DynamoDBMapperFieldModel<T, R> rk = this.rangeKey();
            key.put(rk.name(), (AttributeValue)rk.convert((Object)rangeKey));
        }
        if (key.isEmpty()) {
            throw new DynamoDBMappingException(this.id().err("no key value(s) present", new Object[0]));
        }
        return key;
    }

    public <H, R> T asKey(H hashKey, R rangeKey) {
        T object;
        try {
            object = this.targetType().newInstance();
        }
        catch (Exception e) {
            throw new DynamoDBMappingException(this.id().err("could not instantiate %s", this.targetType()));
        }
        if (hashKey != null) {
            DynamoDBMapperFieldModel<T, H> hk = this.hashKey();
            hk.set(object, hashKey);
        }
        if (rangeKey != null) {
            DynamoDBMapperFieldModel<T, R> rk = this.rangeKey();
            rk.set(object, rangeKey);
        }
        return object;
    }

    public boolean anyKeyGeneratable(T object, DynamoDBMapperConfig config) {
        for (DynamoDBMapperFieldModel<T, Object> field : this.keys()) {
            if (!field.canGenerate(object, config, null)) continue;
            return true;
        }
        return false;
    }

    static interface Properties<T> {
        public Id<T> id();

        public Class<T> targetType();

        public String tableName();

        public static class Buildable<T>
        extends Immutable<T> {
            public Buildable(Properties<T> ... defaults) {
                super(defaults);
            }

            public final Buildable<T> withId(Id<T> id) {
                ((Immutable)this).id = id;
                return this;
            }

            public final Buildable<T> withTargetType(Class<T> targetType) {
                ((Immutable)this).targetType = targetType;
                return this;
            }

            public final Buildable<T> withTableName(String tableName) {
                ((Immutable)this).tableName = tableName;
                return this;
            }
        }

        public static class Immutable<T>
        implements Properties<T> {
            private Id<T> id;
            private Class<T> targetType;
            private String tableName;

            public Immutable(Properties<T> ... defaults) {
                for (Properties<T> d : defaults) {
                    this.targetType = d.targetType();
                    this.tableName = d.tableName();
                    this.id = d.id();
                }
            }

            @Override
            public final Id<T> id() {
                return this.id;
            }

            @Override
            public final Class<T> targetType() {
                return this.targetType;
            }

            @Override
            public final String tableName() {
                return this.tableName;
            }
        }
    }

    static class Builder<T>
    extends Properties.Buildable<T> {
        private final Map<String, DynamoDBMapperFieldModel<T, Object>> fields = new LinkedHashMap<String, DynamoDBMapperFieldModel<T, Object>>();
        private final Map<KeyType, DynamoDBMapperFieldModel<T, Object>> keys = new LinkedHashMap<KeyType, DynamoDBMapperFieldModel<T, Object>>(4);

        public Builder(Properties<T> ... defaults) {
            super(defaults);
        }

        public final Builder<T> with(DynamoDBMapperFieldModel field) {
            if (this.fields.put(field.name(), field) != null) {
                throw new DynamoDBMappingException(field.id().err("must not duplicate attribute name", new Object[0]));
            }
            if (field.keyType() != null && this.keys.put(field.keyType(), field) != null) {
                throw new DynamoDBMappingException(field.id().err("must not specify multiple %s key(s)", new Object[]{field.keyType()}));
            }
            return this;
        }

        public final Map<String, GlobalSecondaryIndex> globalSecondaryIndexes() {
            GlobalSecondaryIndex gsi;
            if (this.tableName() == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, GlobalSecondaryIndex> map = new LinkedHashMap<String, GlobalSecondaryIndex>();
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.HASH)) {
                    if (map.put(indexName, gsi = new GlobalSecondaryIndex().withIndexName(indexName)) != null) {
                        throw new DynamoDBMappingException(field.id().err("must not contain duplicate GSI named %s", indexName));
                    }
                    gsi.withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY));
                    gsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.HASH));
                }
            }
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.RANGE)) {
                    gsi = (GlobalSecondaryIndex)map.get(indexName);
                    if (gsi == null) {
                        throw new DynamoDBMappingException(field.id().err("no HASH key present for GSI named %s", indexName));
                    }
                    gsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.RANGE));
                }
            }
            return Collections.unmodifiableMap(map);
        }

        public final Map<String, LocalSecondaryIndex> localSecondaryIndexes() {
            if (this.tableName() == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, LocalSecondaryIndex> map = new LinkedHashMap<String, LocalSecondaryIndex>();
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.localSecondaryIndexNames()) {
                    LocalSecondaryIndex lsi;
                    if (map.put(indexName, lsi = new LocalSecondaryIndex().withIndexName(indexName)) != null) {
                        throw new DynamoDBMappingException(field.id().err("must not contain duplicate LocalSecondaryIndexes named %s", indexName));
                    }
                    lsi.withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY));
                    lsi.withKeySchema(new KeySchemaElement(this.keys.get((Object)KeyType.HASH).name(), KeyType.HASH));
                    lsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.RANGE));
                }
            }
            return Collections.unmodifiableMap(map);
        }

        public final DynamoDBMapperTableModel<T> build() {
            if (this.tableName() != null && !this.tableName().isEmpty() && this.keys.get((Object)KeyType.HASH) == null) {
                throw new DynamoDBMappingException(this.id().err("does not map HASH key on model", new Object[0]));
            }
            return new DynamoDBMapperTableModel(this);
        }
    }

    public static class Id<T> {
        private final Class<T> type;

        public Id(Class<T> type) {
            this.type = type;
        }

        public Id(Id<T> id) {
            this(id.type);
        }

        public final String err(String message, Object ... args) {
            if (message != null && args.length > 0) {
                try {
                    message = String.format(message, args);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this + ": " + message;
        }

        public boolean equals(Object o) {
            return o instanceof Id && ((Id)o).type == this.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type.getSimpleName();
        }
    }
}

