/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.CreateDevicePoolRequest;
import com.amazonaws.services.devicefarm.model.Rule;
import com.amazonaws.services.devicefarm.model.transform.RuleJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateDevicePoolRequestMarshaller
implements Marshaller<Request<CreateDevicePoolRequest>, CreateDevicePoolRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDevicePoolRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDevicePoolRequest> marshall(CreateDevicePoolRequest createDevicePoolRequest) {
        if (createDevicePoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDevicePoolRequest> request = new DefaultRequest<CreateDevicePoolRequest>(createDevicePoolRequest, "AWSDeviceFarm");
        request.addHeader("X-Amz-Target", "DeviceFarm_20150623.CreateDevicePool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Rule> rulesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDevicePoolRequest.getProjectArn() != null) {
                jsonGenerator.writeFieldName("projectArn").writeValue(createDevicePoolRequest.getProjectArn());
            }
            if (createDevicePoolRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createDevicePoolRequest.getName());
            }
            if (createDevicePoolRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createDevicePoolRequest.getDescription());
            }
            if ((rulesList = createDevicePoolRequest.getRules()) != null) {
                jsonGenerator.writeFieldName("rules");
                jsonGenerator.writeStartArray();
                for (Rule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    RuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

