/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobile;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mobile.AWSMobile;
import com.amazonaws.services.mobile.AWSMobileClientBuilder;
import com.amazonaws.services.mobile.model.AWSMobileException;
import com.amazonaws.services.mobile.model.AccountActionRequiredException;
import com.amazonaws.services.mobile.model.BadRequestException;
import com.amazonaws.services.mobile.model.CreateProjectRequest;
import com.amazonaws.services.mobile.model.CreateProjectResult;
import com.amazonaws.services.mobile.model.DeleteProjectRequest;
import com.amazonaws.services.mobile.model.DeleteProjectResult;
import com.amazonaws.services.mobile.model.DescribeBundleRequest;
import com.amazonaws.services.mobile.model.DescribeBundleResult;
import com.amazonaws.services.mobile.model.DescribeProjectRequest;
import com.amazonaws.services.mobile.model.DescribeProjectResult;
import com.amazonaws.services.mobile.model.ExportBundleRequest;
import com.amazonaws.services.mobile.model.ExportBundleResult;
import com.amazonaws.services.mobile.model.ExportProjectRequest;
import com.amazonaws.services.mobile.model.ExportProjectResult;
import com.amazonaws.services.mobile.model.InternalFailureException;
import com.amazonaws.services.mobile.model.LimitExceededException;
import com.amazonaws.services.mobile.model.ListBundlesRequest;
import com.amazonaws.services.mobile.model.ListBundlesResult;
import com.amazonaws.services.mobile.model.ListProjectsRequest;
import com.amazonaws.services.mobile.model.ListProjectsResult;
import com.amazonaws.services.mobile.model.NotFoundException;
import com.amazonaws.services.mobile.model.ServiceUnavailableException;
import com.amazonaws.services.mobile.model.TooManyRequestsException;
import com.amazonaws.services.mobile.model.UnauthorizedException;
import com.amazonaws.services.mobile.model.UpdateProjectRequest;
import com.amazonaws.services.mobile.model.UpdateProjectResult;
import com.amazonaws.services.mobile.model.transform.CreateProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.CreateProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.DeleteProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.DeleteProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeBundleRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeBundleResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.DescribeProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ExportBundleRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ExportBundleResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ExportProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ExportProjectResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ListBundlesRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ListBundlesResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.ListProjectsRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.ListProjectsResultJsonUnmarshaller;
import com.amazonaws.services.mobile.model.transform.UpdateProjectRequestProtocolMarshaller;
import com.amazonaws.services.mobile.model.transform.UpdateProjectResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMobileClient
extends AmazonWebServiceClient
implements AWSMobile {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMobile.class);
    private static final String DEFAULT_SIGNING_NAME = "AWSMobileHubService";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountActionRequiredException").withModeledClass(AccountActionRequiredException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(UnauthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AWSMobileException.class));

    public static AWSMobileClientBuilder builder() {
        return AWSMobileClientBuilder.standard();
    }

    AWSMobileClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("mobile");
        this.setEndpoint("mobile.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mobile/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mobile/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProjectResult executeCreateProject(CreateProjectRequest createProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProjectRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProjectResult createProjectResult = (CreateProjectResult)response.getAwsResponse();
            return createProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProjectResult executeDeleteProject(DeleteProjectRequest deleteProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProjectRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProjectResult deleteProjectResult = (DeleteProjectResult)response.getAwsResponse();
            return deleteProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBundleResult describeBundle(DescribeBundleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeBundle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBundleResult executeDescribeBundle(DescribeBundleRequest describeBundleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBundleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBundleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBundleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeBundleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeBundleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBundleResult describeBundleResult = (DescribeBundleResult)response.getAwsResponse();
            return describeBundleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProjectResult describeProject(DescribeProjectRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProjectResult executeDescribeProject(DescribeProjectRequest describeProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProjectRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProjectResult describeProjectResult = (DescribeProjectResult)response.getAwsResponse();
            return describeProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportBundleResult exportBundle(ExportBundleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeExportBundle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportBundleResult executeExportBundle(ExportBundleRequest exportBundleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportBundleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportBundleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportBundleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(exportBundleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ExportBundleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportBundleResult exportBundleResult = (ExportBundleResult)response.getAwsResponse();
            return exportBundleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportProjectResult exportProject(ExportProjectRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeExportProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportProjectResult executeExportProject(ExportProjectRequest exportProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportProjectRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(exportProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ExportProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportProjectResult exportProjectResult = (ExportProjectResult)response.getAwsResponse();
            return exportProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBundlesResult listBundles(ListBundlesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListBundles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBundlesResult executeListBundles(ListBundlesRequest listBundlesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBundlesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBundlesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBundlesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listBundlesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBundlesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBundlesResult listBundlesResult = (ListBundlesResult)response.getAwsResponse();
            return listBundlesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListProjects(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProjectsResult executeListProjects(ListProjectsRequest listProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProjectsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listProjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListProjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProjectsResult listProjectsResult = (ListProjectsResult)response.getAwsResponse();
            return listProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProjectResult executeUpdateProject(UpdateProjectRequest updateProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProjectRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProjectResult updateProjectResult = (UpdateProjectResult)response.getAwsResponse();
            return updateProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

