/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastoredata.model.transform;

import com.amazonaws.services.mediastoredata.model.GetObjectResult;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.DateUtils;

public class GetObjectResultJsonUnmarshaller
implements Unmarshaller<GetObjectResult, JsonUnmarshallerContext> {
    private static GetObjectResultJsonUnmarshaller instance;

    @Override
    public GetObjectResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetObjectResult getObjectResult = new GetObjectResult();
        if (context.isStartOfDocument()) {
            if (context.getHeader("Cache-Control") != null) {
                context.setCurrentHeader("Cache-Control");
                getObjectResult.setCacheControl(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Range") != null) {
                context.setCurrentHeader("Content-Range");
                getObjectResult.setContentRange(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Length") != null) {
                context.setCurrentHeader("Content-Length");
                getObjectResult.setContentLength(context.getUnmarshaller(Long.class).unmarshall(context));
            }
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                getObjectResult.setContentType(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("ETag") != null) {
                context.setCurrentHeader("ETag");
                getObjectResult.setETag(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Last-Modified") != null) {
                context.setCurrentHeader("Last-Modified");
                getObjectResult.setLastModified(DateUtils.parseRFC822Date(context.readText()));
            }
        }
        getObjectResult.setStatusCode(context.getHttpResponse().getStatusCode());
        getObjectResult.setBody(context.getHttpResponse().getContent());
        return getObjectResult;
    }

    public static GetObjectResultJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GetObjectResultJsonUnmarshaller();
        }
        return instance;
    }
}

