/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackage.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackage.model.MssEncryption;
import com.amazonaws.services.mediapackage.model.StreamSelection;
import com.amazonaws.services.mediapackage.model.transform.MssPackageMarshaller;
import java.io.Serializable;

public class MssPackage
implements Serializable,
Cloneable,
StructuredPojo {
    private MssEncryption encryption;
    private Integer manifestWindowSeconds;
    private Integer segmentDurationSeconds;
    private StreamSelection streamSelection;

    public void setEncryption(MssEncryption encryption) {
        this.encryption = encryption;
    }

    public MssEncryption getEncryption() {
        return this.encryption;
    }

    public MssPackage withEncryption(MssEncryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public void setManifestWindowSeconds(Integer manifestWindowSeconds) {
        this.manifestWindowSeconds = manifestWindowSeconds;
    }

    public Integer getManifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public MssPackage withManifestWindowSeconds(Integer manifestWindowSeconds) {
        this.setManifestWindowSeconds(manifestWindowSeconds);
        return this;
    }

    public void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.segmentDurationSeconds = segmentDurationSeconds;
    }

    public Integer getSegmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public MssPackage withSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.setSegmentDurationSeconds(segmentDurationSeconds);
        return this;
    }

    public void setStreamSelection(StreamSelection streamSelection) {
        this.streamSelection = streamSelection;
    }

    public StreamSelection getStreamSelection() {
        return this.streamSelection;
    }

    public MssPackage withStreamSelection(StreamSelection streamSelection) {
        this.setStreamSelection(streamSelection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getManifestWindowSeconds() != null) {
            sb.append("ManifestWindowSeconds: ").append(this.getManifestWindowSeconds()).append(",");
        }
        if (this.getSegmentDurationSeconds() != null) {
            sb.append("SegmentDurationSeconds: ").append(this.getSegmentDurationSeconds()).append(",");
        }
        if (this.getStreamSelection() != null) {
            sb.append("StreamSelection: ").append(this.getStreamSelection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage)obj;
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getManifestWindowSeconds() == null ^ this.getManifestWindowSeconds() == null) {
            return false;
        }
        if (other.getManifestWindowSeconds() != null && !other.getManifestWindowSeconds().equals(this.getManifestWindowSeconds())) {
            return false;
        }
        if (other.getSegmentDurationSeconds() == null ^ this.getSegmentDurationSeconds() == null) {
            return false;
        }
        if (other.getSegmentDurationSeconds() != null && !other.getSegmentDurationSeconds().equals(this.getSegmentDurationSeconds())) {
            return false;
        }
        if (other.getStreamSelection() == null ^ this.getStreamSelection() == null) {
            return false;
        }
        return other.getStreamSelection() == null || other.getStreamSelection().equals(this.getStreamSelection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getManifestWindowSeconds() == null ? 0 : this.getManifestWindowSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentDurationSeconds() == null ? 0 : this.getSegmentDurationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getStreamSelection() == null ? 0 : this.getStreamSelection().hashCode());
        return hashCode;
    }

    public MssPackage clone() {
        try {
            return (MssPackage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MssPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

