/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.FecOutputSettings;
import com.amazonaws.services.medialive.model.OutputLocationRef;
import com.amazonaws.services.medialive.model.UdpContainerSettings;
import com.amazonaws.services.medialive.model.transform.UdpOutputSettingsMarshaller;
import java.io.Serializable;

public class UdpOutputSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer bufferMsec;
    private UdpContainerSettings containerSettings;
    private OutputLocationRef destination;
    private FecOutputSettings fecOutputSettings;

    public void setBufferMsec(Integer bufferMsec) {
        this.bufferMsec = bufferMsec;
    }

    public Integer getBufferMsec() {
        return this.bufferMsec;
    }

    public UdpOutputSettings withBufferMsec(Integer bufferMsec) {
        this.setBufferMsec(bufferMsec);
        return this;
    }

    public void setContainerSettings(UdpContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
    }

    public UdpContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public UdpOutputSettings withContainerSettings(UdpContainerSettings containerSettings) {
        this.setContainerSettings(containerSettings);
        return this;
    }

    public void setDestination(OutputLocationRef destination) {
        this.destination = destination;
    }

    public OutputLocationRef getDestination() {
        return this.destination;
    }

    public UdpOutputSettings withDestination(OutputLocationRef destination) {
        this.setDestination(destination);
        return this;
    }

    public void setFecOutputSettings(FecOutputSettings fecOutputSettings) {
        this.fecOutputSettings = fecOutputSettings;
    }

    public FecOutputSettings getFecOutputSettings() {
        return this.fecOutputSettings;
    }

    public UdpOutputSettings withFecOutputSettings(FecOutputSettings fecOutputSettings) {
        this.setFecOutputSettings(fecOutputSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBufferMsec() != null) {
            sb.append("BufferMsec: ").append(this.getBufferMsec()).append(",");
        }
        if (this.getContainerSettings() != null) {
            sb.append("ContainerSettings: ").append(this.getContainerSettings()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getFecOutputSettings() != null) {
            sb.append("FecOutputSettings: ").append(this.getFecOutputSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpOutputSettings)) {
            return false;
        }
        UdpOutputSettings other = (UdpOutputSettings)obj;
        if (other.getBufferMsec() == null ^ this.getBufferMsec() == null) {
            return false;
        }
        if (other.getBufferMsec() != null && !other.getBufferMsec().equals(this.getBufferMsec())) {
            return false;
        }
        if (other.getContainerSettings() == null ^ this.getContainerSettings() == null) {
            return false;
        }
        if (other.getContainerSettings() != null && !other.getContainerSettings().equals(this.getContainerSettings())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getFecOutputSettings() == null ^ this.getFecOutputSettings() == null) {
            return false;
        }
        return other.getFecOutputSettings() == null || other.getFecOutputSettings().equals(this.getFecOutputSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBufferMsec() == null ? 0 : this.getBufferMsec().hashCode());
        hashCode = 31 * hashCode + (this.getContainerSettings() == null ? 0 : this.getContainerSettings().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getFecOutputSettings() == null ? 0 : this.getFecOutputSettings().hashCode());
        return hashCode;
    }

    public UdpOutputSettings clone() {
        try {
            return (UdpOutputSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UdpOutputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

