/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model.transform;

import com.amazonaws.services.lexruntime.model.PostContentResult;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class PostContentResultJsonUnmarshaller
implements Unmarshaller<PostContentResult, JsonUnmarshallerContext> {
    private static PostContentResultJsonUnmarshaller instance;

    @Override
    public PostContentResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        PostContentResult postContentResult = new PostContentResult();
        if (context.isStartOfDocument()) {
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                postContentResult.setContentType(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-intent-name") != null) {
                context.setCurrentHeader("x-amz-lex-intent-name");
                postContentResult.setIntentName(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-slots") != null) {
                context.setCurrentHeader("x-amz-lex-slots");
                postContentResult.setSlots(context.getUnmarshaller(String.class, JsonUnmarshallerContext.UnmarshallerType.JSON_VALUE).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-session-attributes") != null) {
                context.setCurrentHeader("x-amz-lex-session-attributes");
                postContentResult.setSessionAttributes(context.getUnmarshaller(String.class, JsonUnmarshallerContext.UnmarshallerType.JSON_VALUE).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-message") != null) {
                context.setCurrentHeader("x-amz-lex-message");
                postContentResult.setMessage(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-message-format") != null) {
                context.setCurrentHeader("x-amz-lex-message-format");
                postContentResult.setMessageFormat(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-dialog-state") != null) {
                context.setCurrentHeader("x-amz-lex-dialog-state");
                postContentResult.setDialogState(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-slot-to-elicit") != null) {
                context.setCurrentHeader("x-amz-lex-slot-to-elicit");
                postContentResult.setSlotToElicit(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("x-amz-lex-input-transcript") != null) {
                context.setCurrentHeader("x-amz-lex-input-transcript");
                postContentResult.setInputTranscript(context.getUnmarshaller(String.class).unmarshall(context));
            }
        }
        postContentResult.setAudioStream(context.getHttpResponse().getContent());
        return postContentResult;
    }

    public static PostContentResultJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PostContentResultJsonUnmarshaller();
        }
        return instance;
    }
}

